/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.util.Alarm;
import com.intellij.util.ui.Line;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class EditorAdapter {
    private static final Logger LOG = Logger.getInstance(EditorAdapter.class);
    private final Editor myEditor;
    private final Alarm myFlushAlarm = new Alarm();
    private final Collection<Line> myLines = new ArrayList<Line>();
    private final Project myProject;
    private final boolean myScrollToTheEndOnAppend;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void flushStoredLines() {
        ArrayList<Line> lines;
        Collection<Line> collection = this.myLines;
        synchronized (collection) {
            lines = new ArrayList<Line>(this.myLines);
            this.myLines.clear();
        }
        if (this.myEditor.isDisposed() || this.myProject != null && this.myProject.isDisposed()) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(this.writingCommand(lines));
    }

    public EditorAdapter(@NotNull Editor editor, Project project, boolean scrollToTheEndOnAppend) {
        this.myEditor = editor;
        this.myProject = project;
        this.myScrollToTheEndOnAppend = scrollToTheEndOnAppend;
        LOG.assertTrue(this.myEditor.isViewer());
    }

    @NotNull
    public Editor getEditor() {
        return this.myEditor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(String string, TextAttributes attrs) {
        Collection<Line> collection = this.myLines;
        synchronized (collection) {
            this.myLines.add(new Line(string, attrs));
        }
        if (this.myFlushAlarm.isEmpty()) {
            this.myFlushAlarm.addRequest(this::flushStoredLines, 200, ModalityState.NON_MODAL);
        }
    }

    @NotNull
    private Runnable writingCommand(@NotNull Collection<? extends Line> lines) {
        Runnable command = () -> {
            Document document = this.myEditor.getDocument();
            StringBuilder buffer = new StringBuilder();
            for (Line line : lines) {
                buffer.append(line.getValue());
            }
            int endBefore = document.getTextLength();
            document.insertString(endBefore, buffer.toString());
            int endBeforeLine = endBefore;
            for (Line line : lines) {
                this.myEditor.getMarkupModel().addRangeHighlighter(endBeforeLine, Math.min(document.getTextLength(), endBeforeLine + line.getValue().length()), 3000, line.getAttributes(), HighlighterTargetArea.EXACT_RANGE);
                if ((endBeforeLine += line.getValue().length()) <= document.getTextLength()) continue;
                break;
            }
            this.shiftCursorToTheEndOfDocument();
        };
        return () -> CommandProcessor.getInstance().executeCommand(this.myProject, command, "", null, UndoConfirmationPolicy.DEFAULT, this.myEditor.getDocument());
    }

    private void shiftCursorToTheEndOfDocument() {
        if (this.myScrollToTheEndOnAppend) {
            this.myEditor.getCaretModel().moveToOffset(this.myEditor.getDocument().getTextLength());
            this.myEditor.getSelectionModel().removeSelection();
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }
}

