/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.text.DateTimeFormatterBean;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Set;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DateTimeFormatter", storages={@Storage(value="ui-datetime.xml")})
public class DateTimeFormatManager
implements PersistentStateComponent<Element> {
    public static final String DEFAULT_DATE_FORMAT = "dd MMM yyyy";
    private boolean myPrettyFormattingAllowed = true;
    private String myPattern = "dd MMM yyyy";
    private boolean myOverrideSystemDateFormat = false;
    private boolean myUse24HourTime = true;

    @Override
    @Nullable
    public Element getState() {
        return XmlSerializer.serialize(this);
    }

    @Override
    public void loadState(@NotNull Element state) {
        DateTimeFormatManager loaded = XmlSerializer.deserialize(state, DateTimeFormatManager.class);
        XmlSerializerUtil.copyBean((Object)loaded, (Object)this);
    }

    public boolean isOverrideSystemDateFormat() {
        return this.myOverrideSystemDateFormat;
    }

    public void setOverrideSystemDateFormat(boolean overrideSystemDateFormat) {
        this.myOverrideSystemDateFormat = overrideSystemDateFormat;
    }

    public boolean isUse24HourTime() {
        return this.myUse24HourTime;
    }

    public void setUse24HourTime(boolean use24HourTime) {
        this.myUse24HourTime = use24HourTime;
    }

    public void setPrettyFormattingAllowed(boolean prettyFormattingAllowed) {
        this.myPrettyFormattingAllowed = prettyFormattingAllowed;
    }

    @Nullable
    public DateFormat getDateFormat() {
        try {
            return new SimpleDateFormat(this.myPattern);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Set<String> getIds() {
        return DateTimeFormatterBean.EP_NAME.getExtensionList().stream().map(bean -> bean.id).collect(Collectors.toSet());
    }

    @NotNull
    public String getDateFormatPattern() {
        return this.myPattern;
    }

    public void setDateFormatPattern(@NotNull String pattern) {
        try {
            new SimpleDateFormat(pattern);
            this.myPattern = pattern;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isPrettyFormattingAllowed() {
        return this.myPrettyFormattingAllowed;
    }

    public static DateTimeFormatManager getInstance() {
        return ServiceManager.getService(DateTimeFormatManager.class);
    }
}

