/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.proxy.CommonProxy;
import com.intellij.util.proxy.NonStaticAuthenticator;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import org.jetbrains.annotations.NotNull;

public final class IdeaWideAuthenticator
extends NonStaticAuthenticator {
    private static final Logger LOG = Logger.getInstance(IdeaWideAuthenticator.class);
    private final HttpConfigurable myHttpConfigurable;

    public IdeaWideAuthenticator(@NotNull HttpConfigurable configurable) {
        this.myHttpConfigurable = configurable;
    }

    @Override
    public PasswordAuthentication getPasswordAuthentication() {
        String host = CommonProxy.getHostNameReliably(this.getRequestingHost(), this.getRequestingSite(), this.getRequestingURL());
        boolean isProxy = Authenticator.RequestorType.PROXY.equals((Object)this.getRequestorType());
        String prefix = isProxy ? "Proxy authentication: " : "Server authentication: ";
        Application application = ApplicationManager.getApplication();
        if (isProxy) {
            if (this.myHttpConfigurable.USE_HTTP_PROXY) {
                LOG.debug("CommonAuthenticator.getPasswordAuthentication will return common defined proxy");
                return this.myHttpConfigurable.getPromptedAuthentication(host + ":" + this.getRequestingPort(), this.getRequestingPrompt());
            }
            if (this.myHttpConfigurable.USE_PROXY_PAC) {
                LOG.debug("CommonAuthenticator.getPasswordAuthentication will return autodetected proxy");
                if (this.myHttpConfigurable.isGenericPasswordCanceled(host, this.getRequestingPort())) {
                    return null;
                }
                PasswordAuthentication password = this.myHttpConfigurable.getGenericPassword(host, this.getRequestingPort());
                if (password != null) {
                    return password;
                }
                if (application == null || application.isDisposed()) {
                    return null;
                }
                return this.myHttpConfigurable.getGenericPromptedAuthentication(prefix, host, this.getRequestingPrompt(), this.getRequestingPort(), true);
            }
        }
        if (application == null || application.isDisposed()) {
            return null;
        }
        LOG.debug("CommonAuthenticator.getPasswordAuthentication generic authentication will be asked");
        return null;
    }
}

