/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public final class MessageListenerList<T> {
    private final MessageBus myMessageBus;
    private final Topic<T> myTopic;
    private final Map<T, SimpleMessageBusConnection> myListenerToConnectionMap = new ConcurrentHashMap<T, SimpleMessageBusConnection>();

    public MessageListenerList(@NotNull MessageBus messageBus, @NotNull Topic<T> topic) {
        this.myTopic = topic;
        this.myMessageBus = messageBus;
    }

    public void add(@NotNull T listener2) {
        SimpleMessageBusConnection connection = this.myMessageBus.simpleConnect();
        connection.subscribe(this.myTopic, listener2);
        this.myListenerToConnectionMap.put(listener2, connection);
    }

    public void add(final @NotNull T listener2, @NotNull Disposable parentDisposable) {
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                MessageListenerList.this.myListenerToConnectionMap.remove(listener2);
            }
        });
        MessageBusConnection connection = this.myMessageBus.connect(parentDisposable);
        connection.subscribe(this.myTopic, listener2);
        this.myListenerToConnectionMap.put(listener2, (SimpleMessageBusConnection)connection);
    }

    public void remove(@NotNull T listener2) {
        SimpleMessageBusConnection connection = this.myListenerToConnectionMap.remove(listener2);
        if (connection != null) {
            connection.disconnect();
        }
    }
}

