/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.OverrideOnly
public abstract class SingleEntryIndexer<V>
implements DataIndexer<Integer, V, FileContent> {
    private final boolean myAcceptNullValues;

    protected SingleEntryIndexer(boolean acceptNullValues) {
        this.myAcceptNullValues = acceptNullValues;
    }

    @NotNull
    public final Map<Integer, V> map(@NotNull FileContent inputData) {
        V value = this.computeValue(inputData);
        if (value == null && !this.myAcceptNullValues) {
            return Collections.emptyMap();
        }
        VirtualFile file = inputData.getFile();
        int key = file instanceof LightVirtualFile ? -1 : Math.abs(FileBasedIndex.getFileId(file));
        return Collections.singletonMap(key, value);
    }

    @Nullable
    protected abstract V computeValue(@NotNull FileContent var1);

    @ApiStatus.Internal
    public boolean isAcceptNullValues() {
        return this.myAcceptNullValues;
    }
}

