/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.SingleEntryIndexer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.OverrideOnly
public abstract class SingleEntryFileBasedIndexExtension<V>
extends FileBasedIndexExtension<Integer, V> {
    @NotNull
    public final KeyDescriptor<Integer> getKeyDescriptor() {
        return EnumeratorIntegerDescriptor.INSTANCE;
    }

    @Override
    public boolean dependsOnFileContent() {
        return true;
    }

    @Override
    public int getCacheSize() {
        return 5;
    }

    @NotNull
    public abstract SingleEntryIndexer<V> getIndexer();

    @Override
    public boolean keyIsUniqueForIndexedFile() {
        return true;
    }

    @Deprecated
    public static int getFileKey(@NotNull VirtualFile file) {
        return Math.abs(FileBasedIndex.getFileId(file));
    }
}

