/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.BitSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IdFilter {
    private static final Logger LOG = Logger.getInstance(IdFilter.class);
    private static final Key<CachedValue<IdFilter>> INSIDE_PROJECT = Key.create((String)"INSIDE_PROJECT");
    private static final Key<CachedValue<IdFilter>> OUTSIDE_PROJECT = Key.create((String)"OUTSIDE_PROJECT");

    @NotNull
    public static IdFilter getProjectIdFilter(@NotNull Project project, boolean includeNonProjectItems) {
        Key<CachedValue<IdFilter>> key = includeNonProjectItems ? OUTSIDE_PROJECT : INSIDE_PROJECT;
        CachedValueProvider provider = () -> CachedValueProvider.Result.create(IdFilter.buildProjectIdFilter(project, includeNonProjectItems), ProjectRootManager.getInstance(project), VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS);
        return CachedValuesManager.getManager(project).getCachedValue((UserDataHolder)project, key, provider, false);
    }

    @NotNull
    private static IdFilter buildProjectIdFilter(final Project project, final boolean includeNonProjectItems) {
        long started = System.currentTimeMillis();
        final BitSet idSet = new BitSet();
        ContentIterator iterator = fileOrDir -> {
            idSet.set(((VirtualFileWithId)((Object)fileOrDir)).getId());
            ProgressManager.checkCanceled();
            return true;
        };
        if (!includeNonProjectItems) {
            ProjectRootManager.getInstance(project).getFileIndex().iterateContent(iterator);
        } else {
            FileBasedIndex.getInstance().iterateIndexableFiles(iterator, project, ProgressIndicatorProvider.getGlobalProgressIndicator());
        }
        if (LOG.isDebugEnabled()) {
            long elapsed = System.currentTimeMillis() - started;
            LOG.debug("Done filter (includeNonProjectItems=" + includeNonProjectItems + ") in " + elapsed + "ms. Total files in set: " + idSet.cardinality());
        }
        return new IdFilter(){

            @Override
            public boolean containsFileId(int id) {
                return id >= 0 && idSet.get(id);
            }

            @Override
            @NotNull
            public GlobalSearchScope getEffectiveFilteringScope() {
                return includeNonProjectItems ? GlobalSearchScope.allScope(project) : GlobalSearchScope.projectScope(project);
            }
        };
    }

    public abstract boolean containsFileId(int var1);

    @Nullable
    public GlobalSearchScope getEffectiveFilteringScope() {
        return null;
    }
}

