/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageTargetProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class UsageTargetUtil {
    private static final ExtensionPointName<UsageTargetProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.usageTargetProvider");

    public static UsageTarget[] findUsageTargets(@NotNull DataProvider dataProvider) {
        PsiElement psiElement;
        Editor editor = CommonDataKeys.EDITOR.getData(dataProvider);
        PsiFile file = CommonDataKeys.PSI_FILE.getData(dataProvider);
        ArrayList result = new ArrayList();
        if (file != null && editor != null) {
            UsageTarget[] targets = UsageTargetUtil.findUsageTargets(editor, file);
            Collections.addAll(result, targets);
        }
        if ((psiElement = CommonDataKeys.PSI_ELEMENT.getData(dataProvider)) != null) {
            UsageTarget[] targets = UsageTargetUtil.findUsageTargets(psiElement);
            Collections.addAll(result, targets);
        }
        return result.isEmpty() ? null : result.toArray(UsageTarget.EMPTY_ARRAY);
    }

    public static UsageTarget @NotNull [] findUsageTargets(@NotNull Editor editor, @NotNull PsiFile file) {
        ArrayList result = new ArrayList();
        for (UsageTargetProvider provider : UsageTargetUtil.getProviders(file.getProject())) {
            UsageTarget[] targets = provider.getTargets(editor, file);
            if (targets == null) continue;
            Collections.addAll(result, targets);
        }
        return result.isEmpty() ? UsageTarget.EMPTY_ARRAY : result.toArray(UsageTarget.EMPTY_ARRAY);
    }

    public static UsageTarget @NotNull [] findUsageTargets(@NotNull PsiElement psiElement) {
        ArrayList result = new ArrayList();
        for (UsageTargetProvider provider : UsageTargetUtil.getProviders(psiElement.getProject())) {
            UsageTarget[] targets = provider.getTargets(psiElement);
            if (targets == null) continue;
            Collections.addAll(result, targets);
        }
        return result.isEmpty() ? UsageTarget.EMPTY_ARRAY : result.toArray(UsageTarget.EMPTY_ARRAY);
    }

    @NotNull
    private static List<UsageTargetProvider> getProviders(@NotNull Project project) {
        return DumbService.getDumbAwareExtensions(project, EP_NAME);
    }
}

