/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.ui.jcef.JBCefLoadHtmlResourceHandler;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefSchemeHandlerFactory;
import org.cef.handler.CefResourceHandler;
import org.cef.network.CefRequest;
import org.jetbrains.annotations.NotNull;

class JBCefFileSchemeHandlerFactory
implements CefSchemeHandlerFactory {
    public static final String FILE_SCHEME_NAME = "file";
    public static final String LOADHTML_RANDOM_URL_PREFIX = "file:///jbcefbrowser/";
    public static final Map<CefBrowser, Map<String, String>> LOADHTML_REQUEST_MAP = ContainerUtil.createWeakMap();

    JBCefFileSchemeHandlerFactory() {
    }

    public CefResourceHandler create(CefBrowser browser, CefFrame frame, String schemeName, CefRequest request) {
        String html;
        if (!FILE_SCHEME_NAME.equals(schemeName)) {
            return null;
        }
        String url = request.getURL();
        if (url == null) {
            return null;
        }
        Map<String, String> map = LOADHTML_REQUEST_MAP.get(browser);
        if (map != null && (html = map.remove(request.getURL())) != null) {
            return new JBCefLoadHtmlResourceHandler(html);
        }
        return null;
    }

    @NotNull
    public static String registerLoadHTMLRequest(@NotNull CefBrowser browser, @NotNull String html, @NotNull String origUrl) {
        String fileUrl = JBCefFileSchemeHandlerFactory.makeFileUrl(origUrl);
        JBCefFileSchemeHandlerFactory.getInitMap(browser).put(fileUrl, html);
        return fileUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Map<String, String> getInitMap(@NotNull CefBrowser browser) {
        Map<String, String> map = LOADHTML_REQUEST_MAP.get(browser);
        if (map == null) {
            Map<CefBrowser, Map<String, String>> map2 = LOADHTML_REQUEST_MAP;
            synchronized (map2) {
                map = LOADHTML_REQUEST_MAP.get(browser);
                if (map == null) {
                    map = Collections.synchronizedMap(new HashMap());
                    LOADHTML_REQUEST_MAP.put(browser, map);
                }
            }
        }
        return map;
    }

    @NotNull
    public static String makeFileUrl(@NotNull String url) {
        if (url.startsWith("file://")) {
            return url;
        }
        return LOADHTML_RANDOM_URL_PREFIX + new Random().nextInt(Integer.MAX_VALUE) + "#url=" + url;
    }
}

