/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import java.util.Date;
import java.util.Objects;
import org.cef.network.CefCookie;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBCefCookie {
    private final CefCookie myCefCookie;

    public JBCefCookie(CefCookie cefCookie) {
        this.myCefCookie = cefCookie;
    }

    public JBCefCookie(@NotNull String name, @NotNull String value, @NotNull String domain, @NotNull String path2, boolean secure, boolean httponly, @Nullable Date creation, @Nullable Date lastAccess, boolean hasExpires, @Nullable Date expires) {
        this(new CefCookie(name, value, domain, path2, secure, httponly, creation, lastAccess, hasExpires, expires));
    }

    public JBCefCookie(@NotNull String name, @NotNull String value, @NotNull String domain, @NotNull String path2, boolean secure, boolean httponly) {
        this(name, value, domain, path2, secure, httponly, null, null, false, null);
    }

    @NotNull
    public CefCookie getCefCookie() {
        return this.myCefCookie;
    }

    @NotNull
    public String getName() {
        return this.myCefCookie.name;
    }

    @NotNull
    public String getValue() {
        return this.myCefCookie.value;
    }

    @NotNull
    public String getDomain() {
        return this.myCefCookie.domain;
    }

    @NotNull
    public String getPath() {
        return this.myCefCookie.path;
    }

    public boolean isSecure() {
        return this.myCefCookie.secure;
    }

    public boolean isHttpOnly() {
        return this.myCefCookie.httponly;
    }

    @Nullable
    public Date getCreation() {
        return this.myCefCookie.creation;
    }

    @Nullable
    public Date getLastAccess() {
        return this.myCefCookie.lastAccess;
    }

    public boolean hasExpires() {
        return this.myCefCookie.hasExpires;
    }

    @Nullable
    public Date getExpires() {
        return this.myCefCookie.expires;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JBCefCookie cookie = (JBCefCookie)o;
        return this.getName().equals(cookie.getName()) && this.getValue().equals(cookie.getValue()) && this.getDomain().equals(cookie.getDomain()) && this.getPath().equals(cookie.getPath()) && this.isSecure() == cookie.isSecure() && this.isHttpOnly() == cookie.isHttpOnly();
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getValue(), this.getDomain(), this.getPath(), this.isSecure(), this.isHttpOnly());
    }
}

