/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.dualView;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.HighlightableCellRenderer;
import com.intellij.ui.dualView.DualTreeElement;
import com.intellij.ui.dualView.TableCellRendererWrapper;
import com.intellij.ui.table.ItemsProvider;
import com.intellij.ui.table.SelectionProvider;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableCellRenderer;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.SortableColumnModel;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class TreeTableView
extends TreeTable
implements ItemsProvider,
SelectionProvider {
    private static final Logger LOG = Logger.getInstance(TreeTableView.class);

    public TreeTableView(ListTreeTableModelOnColumns treeTableModel) {
        super(treeTableModel);
        this.setRootVisible(false);
        this.setTreeCellRenderer(new TreeCellRenderer(){
            private final TreeCellRenderer myBaseRenderer = new HighlightableCellRenderer();

            @Override
            public Component getTreeCellRendererComponent(JTree tree1, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                JComponent result = (JComponent)this.myBaseRenderer.getTreeCellRendererComponent(tree1, value, selected, expanded, leaf, row, hasFocus);
                result.setOpaque(!selected);
                return result;
            }
        });
        this.setSizes();
    }

    @Override
    public void setTableModel(TreeTableModel treeTableModel) {
        super.setTableModel(treeTableModel);
        LOG.assertTrue(treeTableModel instanceof SortableColumnModel);
    }

    private void setSizes() {
        ColumnInfo[] columns = ((ListTreeTableModelOnColumns)this.getTableModel()).getColumns();
        for (int i = 0; i < columns.length; ++i) {
            ColumnInfo columnInfo = columns[i];
            TableColumn column = this.getColumnModel().getColumn(i);
            if (columnInfo.getWidth(this) > 0) {
                int width = columnInfo.getWidth(this);
                column.setMaxWidth(width);
                column.setMinWidth(width);
                continue;
            }
            String preferredValue = columnInfo.getPreferredStringValue();
            if (preferredValue == null) continue;
            int width = this.getFontMetrics(this.getFont()).stringWidth(preferredValue) + columnInfo.getAdditionalWidth();
            column.setPreferredWidth(width);
        }
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        TableCellEditor editor = this.getColumnInfo(column).getEditor(this.getRowElement(row));
        return editor == null ? super.getCellEditor(row, column) : editor;
    }

    @Override
    public TreeTableCellRenderer createTableRenderer(TreeTableModel treeTableModel) {
        return new TreeTableCellRenderer(this, this.getTree()){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JComponent component = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                component.setOpaque(isSelected);
                return component;
            }
        };
    }

    ListTreeTableModelOnColumns getTreeViewModel() {
        return (ListTreeTableModelOnColumns)this.getTableModel();
    }

    public List<DualTreeElement> getFlattenItems() {
        List items = this.getTreeViewModel().getItems();
        return ContainerUtil.findAll((Collection)items, object -> object.shouldBeInTheFlatView());
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer renderer = this.getColumnInfo(column).getRenderer(this.getRowElement(row));
        TableCellRenderer baseRenderer = renderer == null ? super.getCellRenderer(row, column) : renderer;
        return new CellRendererWrapper(baseRenderer);
    }

    protected Object getRowElement(int row) {
        return this.getTree().getPathForRow(row).getLastPathComponent();
    }

    protected final ColumnInfo<Object, ?> getColumnInfo(int column) {
        return this.getTreeViewModel().getColumnInfos()[this.convertColumnIndexToModel(column)];
    }

    @Override
    public List getItems() {
        return this.getTreeViewModel().getItems();
    }

    @Override
    public List getSelection() {
        TreeTableTree tree = this.getTree();
        if (tree == null) {
            return Collections.emptyList();
        }
        int[] rows = this.getSelectedRows();
        ArrayList<Object> result = new ArrayList<Object>();
        for (int row : rows) {
            TreePath pathForRow = tree.getPathForRow(row);
            if (pathForRow == null) continue;
            result.add(pathForRow.getLastPathComponent());
        }
        return result;
    }

    @Override
    public void addSelection(Object item) {
        this.getTree().setExpandsSelectedPaths(true);
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)item;
        this.addSelectedPath(new TreePath(treeNode.getPath()));
    }

    public static class CellRendererWrapper
    implements TableCellRendererWrapper {
        @NotNull
        private final TableCellRenderer myBaseRenderer;

        public CellRendererWrapper(@NotNull TableCellRenderer baseRenderer) {
            this.myBaseRenderer = baseRenderer;
        }

        @Override
        @NotNull
        public TableCellRenderer getBaseRenderer() {
            return this.myBaseRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent rendererComponent = (JComponent)this.myBaseRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (isSelected) {
                rendererComponent.setBackground(table.getSelectionBackground());
                rendererComponent.setForeground(table.getSelectionForeground());
            } else {
                Color bg = table.getBackground();
                rendererComponent.setBackground(bg);
                rendererComponent.setForeground(table.getForeground());
            }
            rendererComponent.setOpaque(isSelected);
            return rendererComponent;
        }
    }
}

