/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.fields;

import com.intellij.ui.scale.JBUIScale;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public interface ExtendableTextComponent {
    public static final String VARIANT = "extendable";

    public List<Extension> getExtensions();

    public void setExtensions(Extension ... var1);

    public void setExtensions(Collection<? extends Extension> var1);

    public void addExtension(@NotNull Extension var1);

    public void removeExtension(@NotNull Extension var1);

    public static interface Extension {
        public Icon getIcon(boolean var1);

        default public int getIconGap() {
            return JBUIScale.scale((int)5);
        }

        default public int getPreferredSpace() {
            Icon icon1 = this.getIcon(true);
            Icon icon2 = this.getIcon(false);
            if (icon1 == null && icon2 == null) {
                return 0;
            }
            if (icon1 == null) {
                return this.getIconGap() + icon2.getIconWidth();
            }
            if (icon2 == null) {
                return this.getIconGap() + icon1.getIconWidth();
            }
            return this.getIconGap() + Math.max(icon1.getIconWidth(), icon2.getIconWidth());
        }

        default public int getAfterIconOffset() {
            return 0;
        }

        default public boolean isIconBeforeText() {
            return false;
        }

        default public Runnable getActionOnClick() {
            return null;
        }

        default public String getTooltip() {
            return null;
        }

        public static Extension create(@NotNull Icon icon, String tooltip, Runnable action) {
            return Extension.create(icon, icon, tooltip, action);
        }

        public static Extension create(final @NotNull Icon defaultIcon, final @NotNull Icon hoveredIcon, final @Nls String tooltip, final Runnable action) {
            return new Extension(){

                @Override
                public Icon getIcon(boolean hovered) {
                    return hovered ? hoveredIcon : defaultIcon;
                }

                @Override
                public String getTooltip() {
                    return tooltip;
                }

                @Override
                public Runnable getActionOnClick() {
                    return action;
                }
            };
        }
    }
}

