/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ColoredItem;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.BackgroundSupplier;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.list.ListCellBackgroundSupplier;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WideSelectionListUI
extends BasicListUI {
    private static final Logger LOG = Logger.getInstance(WideSelectionListUI.class);
    private Rectangle myPaintBounds;

    @Override
    public void paint(Graphics g, JComponent c) {
        this.myPaintBounds = 0 != this.list.getLayoutOrientation() ? null : g.getClipBounds();
        super.paint(g, c);
    }

    protected void paintCell(Graphics g, int row, Rectangle rowBounds, ListCellRenderer renderer, ListModel model, ListSelectionModel selectionModel, int leadSelectionIndex) {
        if (0 > row || row >= model.getSize()) {
            return;
        }
        boolean selected = selectionModel.isSelectedIndex(row);
        Rectangle paintBounds = this.myPaintBounds;
        if (paintBounds != null) {
            Component component;
            boolean focused = row == leadSelectionIndex && (!this.list.isFocusable() || this.list.hasFocus());
            Object value = model.getElementAt(row);
            Color background = WideSelectionListUI.getBackground(this.list, value, row);
            if (background != null) {
                g.setColor(background);
                g.fillRect(rowBounds.x, rowBounds.y, rowBounds.width, rowBounds.height);
            }
            if ((component = renderer.getListCellRendererComponent(this.list, value, row, selected, focused)) != null) {
                if (this.rendererPane != component.getParent()) {
                    this.rendererPane.add(component);
                }
                g.setClip(paintBounds.x, paintBounds.y, paintBounds.width, paintBounds.height);
                WideSelectionListUI.paintRenderer(g, rowBounds.x, rowBounds.y, rowBounds.width, rowBounds.height, this.list, component);
                g.clipRect(rowBounds.x, rowBounds.y, rowBounds.width, rowBounds.height);
            }
        }
        try {
            super.paintCell(g, row, rowBounds, renderer, model, selectionModel, leadSelectionIndex);
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            LOG.error("model asynchronously modified: " + model.getClass() + " in " + this.list, (Throwable)exception);
        }
        if (!SystemInfo.isMac && g instanceof Graphics2D && row == leadSelectionIndex && this.list.hasFocus()) {
            int x = rowBounds.x;
            int width = rowBounds.width;
            if (0 == this.list.getLayoutOrientation()) {
                x = 0;
                width = this.list.getWidth();
                Container parent = this.list.getParent();
                if (parent instanceof JViewport) {
                    x = -this.list.getX();
                    width = parent.getWidth();
                }
            }
            if (!selected) {
                g.setColor(UIUtil.getListSelectionBackground((boolean)true));
                g.setClip(x, rowBounds.y, width, rowBounds.height);
                RectanglePainter.DRAW.paint((Graphics2D)g, x, rowBounds.y, width, rowBounds.height, (Object)0);
            } else if (WideSelectionListUI.isLeadSelectionNeeded(this.list, row)) {
                g.setColor(UIUtil.getListBackground());
                g.setClip(x, rowBounds.y, width, rowBounds.height);
                RectanglePainter.DRAW.paint((Graphics2D)g, x + 1, rowBounds.y + 1, width - 2, rowBounds.height - 2, (Object)0);
            }
        }
    }

    private static boolean isLeadSelectionNeeded(@NotNull JList list, int row) {
        return list.getMinSelectionIndex() < list.getMaxSelectionIndex() && list.isSelectedIndex(row - 1) && list.isSelectedIndex(row + 1);
    }

    @Nullable
    private static Color getBackground(@NotNull JList<Object> list, @Nullable Object value, int row) {
        BackgroundSupplier supplier;
        Color background;
        Color background2;
        if (value instanceof ColoredItem && (background2 = ((ColoredItem)value).getColor()) != null) {
            return background2;
        }
        if (value instanceof BackgroundSupplier && (background = (supplier = (BackgroundSupplier)value).getElementBackground(row)) != null) {
            return background;
        }
        if (list instanceof ListCellBackgroundSupplier && (background2 = ((ListCellBackgroundSupplier)((Object)list)).getCellBackground(value, row)) != null) {
            return background2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void paintRenderer(Graphics g, int x, int y, int width, int height, Component owner, Component renderer) {
        g.clipRect(0, y, owner.getWidth(), height);
        WideSelectionListUI.paintBackground(g, y, height, owner, renderer);
        if (renderer instanceof Container) {
            Component[] children;
            Container container = (Container)renderer;
            Component[] componentArray = container.getTreeLock();
            synchronized (componentArray) {
                children = container.getComponents();
            }
            if (children.length > 0) {
                renderer.setBounds(x, y, width, height);
                renderer.validate();
                for (Component child : children) {
                    if (0 != child.getX() || width != child.getWidth() || 0 >= child.getHeight()) continue;
                    WideSelectionListUI.paintBackground(g, y + child.getY(), child.getHeight(), owner, child);
                }
            }
        }
    }

    private static void paintBackground(Graphics g, int y, int height, Component owner, Component child) {
        Color color;
        if (child.isOpaque() && (color = child.getBackground()) != null && !color.equals(owner.getBackground())) {
            g.setColor(color);
            g.fillRect(0, y, owner.getWidth(), height);
        }
    }

    public Rectangle getCellBounds(JList list, int index1, int index2) {
        Rectangle bounds = super.getCellBounds(list, index1, index2);
        if (bounds != null && index1 == index2 && list instanceof JBList && 0 == list.getLayoutOrientation() && ((JBList)list).getExpandableItemsHandler().getExpandedItems().contains(index1)) {
            JScrollBar bar;
            JScrollPane pane = JBScrollPane.findScrollPane(list);
            JScrollBar jScrollBar = bar = pane == null ? null : pane.getVerticalScrollBar();
            if (bar != null && !bar.isOpaque()) {
                bounds.width += bar.getWidth();
            }
        }
        return bounds;
    }

    @Override
    protected void updateLayoutState() {
        block11: {
            int fixedCellWidth;
            if (this.list.getLayoutOrientation() != 0) {
                super.updateLayoutState();
                return;
            }
            int fixedCellHeight = this.list.getFixedCellHeight();
            this.cellWidth = fixedCellWidth = this.list.getFixedCellWidth();
            if (fixedCellHeight != -1) {
                this.cellHeight = fixedCellHeight;
                this.cellHeights = null;
            } else {
                this.cellHeight = -1;
                this.cellHeights = new int[this.list.getModel().getSize()];
            }
            if (fixedCellWidth != -1 && fixedCellHeight != -1) break block11;
            ListModel dataModel = this.list.getModel();
            int dataModelSize = dataModel.getSize();
            ListCellRenderer renderer = this.list.getCellRenderer();
            if (renderer != null) {
                for (int index = 0; index < dataModelSize; ++index) {
                    Object value = dataModel.getElementAt(index);
                    Component c = renderer.getListCellRendererComponent(this.list, value, index, false, false);
                    this.rendererPane.add(c);
                    Dimension cellSize = c.getPreferredSize();
                    if (UIUtil.getClientProperty((Object)c, (Object)"IgnoreListRowHeight") == null) {
                        cellSize = UIUtil.updateListRowHeight((Dimension)cellSize);
                    }
                    if (fixedCellWidth == -1) {
                        this.cellWidth = Math.max(cellSize.width, this.cellWidth);
                    }
                    if (fixedCellHeight != -1) continue;
                    this.cellHeights[index] = cellSize.height;
                }
            } else {
                if (this.cellWidth == -1) {
                    this.cellWidth = 0;
                }
                if (this.cellHeights == null) {
                    this.cellHeights = new int[dataModelSize];
                }
                for (int index = 0; index < dataModelSize; ++index) {
                    this.cellHeights[index] = 0;
                }
            }
        }
    }

    public static ComponentUI createUI(JComponent list) {
        return new WideSelectionListUI();
    }
}

