/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Couple;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.ui.UIUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.text.JTextComponent;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScrollingUtil {
    private static final Logger LOG = Logger.getInstance(ScrollingUtil.class);
    @NonNls
    private static final String SCROLL_UP_ACTION_ID = "scrollUp";
    @NonNls
    private static final String SCROLL_DOWN_ACTION_ID = "scrollDown";
    @NonNls
    private static final String SELECT_PREVIOUS_ROW_ACTION_ID = "selectPreviousRow";
    @NonNls
    private static final String SELECT_NEXT_ROW_ACTION_ID = "selectNextRow";
    @NonNls
    private static final String SELECT_LAST_ROW_ACTION_ID = "selectLastRow";
    @NonNls
    private static final String SELECT_FIRST_ROW_ACTION_ID = "selectFirstRow";
    @NonNls
    private static final String MOVE_HOME_ID = "MOVE_HOME";
    @NonNls
    private static final String MOVE_END_ID = "MOVE_END";
    public static final int ROW_PADDING = 2;

    public static void selectItem(@NotNull JList<?> list, int index) {
        LOG.assertTrue(index >= 0);
        LOG.assertTrue(index < list.getModel().getSize());
        ScrollingUtil.ensureIndexIsVisible(list, index, 0);
        list.setSelectedIndex(index);
    }

    public static void ensureSelectionExists(@NotNull JList<?> list) {
        int size = list.getModel().getSize();
        if (size == 0) {
            list.clearSelection();
            return;
        }
        int selectedIndex = list.getSelectedIndex();
        if (selectedIndex < 0 || selectedIndex >= size) {
            selectedIndex = 0;
        }
        ScrollingUtil.selectItem(list, selectedIndex);
    }

    public static <T> boolean selectItem(@NotNull JList<T> list, @NotNull T item) {
        ListModel<T> model = list.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            T anItem = model.getElementAt(i);
            if (!item.equals(anItem)) continue;
            ScrollingUtil.selectItem(list, i);
            return true;
        }
        return false;
    }

    public static void movePageUp(JList<?> list) {
        Rectangle cellBounds;
        int bottom;
        int visible = ScrollingUtil.getVisibleRowCount(list);
        ListSelectionModel selectionModel = list.getSelectionModel();
        if (visible <= 0) {
            ScrollingUtil.moveHome(list);
            return;
        }
        int size = list.getModel().getSize();
        int decrement = visible - 1;
        int index = Math.max(list.getSelectedIndex() - decrement, 0);
        int top = list.getFirstVisibleIndex() - decrement;
        if (top < 0) {
            top = 0;
        }
        if ((bottom = top + visible - 1) >= size) {
            bottom = size - 1;
        }
        if ((cellBounds = list.getCellBounds(top, bottom)) == null) {
            ScrollingUtil.moveHome(list);
            return;
        }
        list.scrollRectToVisible(cellBounds);
        selectionModel.setSelectionInterval(index, index);
        list.ensureIndexIsVisible(index);
    }

    public static void movePageDown(@NotNull JList<?> list) {
        Rectangle cellBounds;
        int visible = ScrollingUtil.getVisibleRowCount(list);
        if (visible <= 0) {
            ScrollingUtil.moveEnd(list);
            return;
        }
        int size = list.getModel().getSize();
        int increment = visible - 1;
        int index = Math.min(list.getSelectedIndex() + increment, size - 1);
        int top = list.getFirstVisibleIndex() + increment;
        int bottom = top + visible - 1;
        if (bottom >= size) {
            bottom = size - 1;
        }
        if ((cellBounds = list.getCellBounds(top, bottom)) == null) {
            ScrollingUtil.moveEnd(list);
            return;
        }
        list.scrollRectToVisible(cellBounds);
        list.setSelectedIndex(index);
        list.ensureIndexIsVisible(index);
    }

    public static void moveHome(@NotNull JList<?> list) {
        list.setSelectedIndex(0);
        list.ensureIndexIsVisible(0);
    }

    public static void moveEnd(@NotNull JList<?> list) {
        int index = list.getModel().getSize() - 1;
        list.setSelectedIndex(index);
        list.ensureIndexIsVisible(index);
    }

    public static void ensureIndexIsVisible(@NotNull JList<?> list, int index, int moveDirection) {
        ScrollingUtil._ensureIndexIsVisible(list, index, moveDirection, list.getModel().getSize());
    }

    public static void ensureIndexIsVisible(@NotNull JTable table, int index, int moveDirection) {
        ScrollingUtil._ensureIndexIsVisible(table, index, moveDirection, table.getRowCount());
    }

    private static void _ensureIndexIsVisible(@NotNull JComponent c, int index, int moveDirection, int size) {
        int bottom;
        int top;
        int visible = ScrollingUtil.visibleRowCount(c);
        if (moveDirection == 0) {
            top = index - (visible - 1) / 2;
            bottom = top + visible - 1;
        } else if (moveDirection < 0) {
            top = index - 2;
            bottom = index;
        } else {
            top = index;
            bottom = index + 2;
        }
        if (top < 0) {
            top = 0;
        }
        if (bottom >= size) {
            bottom = size - 1;
        }
        ScrollingUtil._ensureRangeIsVisible(c, top, bottom);
    }

    public static void ensureRangeIsVisible(@NotNull JList<?> list, int top, int bottom) {
        Rectangle cellBounds;
        int size = list.getModel().getSize();
        if (top < 0) {
            top = 0;
        }
        if (bottom >= size) {
            bottom = size - 1;
        }
        if ((cellBounds = list.getCellBounds(top, bottom)) != null) {
            cellBounds.x = 0;
            list.scrollRectToVisible(cellBounds);
        }
    }

    private static void _ensureRangeIsVisible(@NotNull JComponent c, int top, int bottom) {
        if (c instanceof JList) {
            ScrollingUtil.ensureRangeIsVisible((JList)c, top, bottom);
        } else if (c instanceof JTable) {
            JTable table = (JTable)c;
            Rectangle cellBounds = ScrollingUtil.getCellBounds(table, top, bottom);
            cellBounds.x = 0;
            table.scrollRectToVisible(cellBounds);
        }
    }

    public static boolean isIndexFullyVisible(@NotNull JList<?> list, int index) {
        int first = list.getFirstVisibleIndex();
        int last = list.getLastVisibleIndex();
        if (index < 0 || first < 0 || last < 0 || index < first || index > last) {
            return false;
        }
        if (index > first && index < last) {
            return true;
        }
        return list.getVisibleRect().contains(list.getCellBounds(index, index));
    }

    private static int getVisibleRowCount(@NotNull JList<?> list) {
        return list.getLastVisibleIndex() - list.getFirstVisibleIndex() + 1;
    }

    public static void moveDown(@NotNull JList<?> list, @JdkConstants.InputEventMask int modifiers) {
        ScrollingUtil._moveDown(list, list.getSelectionModel(), modifiers, list.getModel().getSize(), UISettings.getInstance().getCycleScrolling());
    }

    private static void selectOrAddSelection(@NotNull ListSelectionModel selectionModel, int indexToSelect, @JdkConstants.InputEventMask int modifiers) {
        if (selectionModel.getSelectionMode() == 0) {
            selectionModel.setSelectionInterval(indexToSelect, indexToSelect);
        } else {
            if ((modifiers & 0x40) == 0) {
                selectionModel.removeSelectionInterval(selectionModel.getMinSelectionIndex(), selectionModel.getMaxSelectionIndex());
            }
            selectionModel.addSelectionInterval(indexToSelect, indexToSelect);
        }
    }

    public static void installActions(@NotNull JList<?> list) {
        ScrollingUtil.installActions(list, null);
    }

    public static void installActions(@NotNull JList<?> list, @Nullable JComponent focusParent) {
        ActionMap actionMap = list.getActionMap();
        actionMap.put(SCROLL_UP_ACTION_ID, new MoveAction(SCROLL_UP_ACTION_ID, list));
        actionMap.put(SCROLL_DOWN_ACTION_ID, new MoveAction(SCROLL_DOWN_ACTION_ID, list));
        actionMap.put(SELECT_PREVIOUS_ROW_ACTION_ID, new MoveAction(SELECT_PREVIOUS_ROW_ACTION_ID, list));
        actionMap.put(SELECT_NEXT_ROW_ACTION_ID, new MoveAction(SELECT_NEXT_ROW_ACTION_ID, list));
        actionMap.put(SELECT_LAST_ROW_ACTION_ID, new MoveAction(SELECT_LAST_ROW_ACTION_ID, list));
        actionMap.put(SELECT_FIRST_ROW_ACTION_ID, new MoveAction(SELECT_FIRST_ROW_ACTION_ID, list));
        actionMap.put(MOVE_HOME_ID, new MoveAction(MOVE_HOME_ID, list));
        actionMap.put(MOVE_END_ID, new MoveAction(MOVE_END_ID, list));
        ScrollingUtil.maybeInstallDefaultShortcuts(list);
        ScrollingUtil.installMoveUpAction(list, focusParent);
        ScrollingUtil.installMoveDownAction(list, focusParent);
        ScrollingUtil.installMovePageUpAction(list, focusParent);
        ScrollingUtil.installMovePageDownAction(list, focusParent);
        if (!(focusParent instanceof JTextComponent)) {
            ScrollingUtil.installMoveHomeAction(list, focusParent);
            ScrollingUtil.installMoveEndAction(list, focusParent);
        }
    }

    public static void redirectExpandSelection(final @NotNull JList<?> list, @Nullable JComponent focusParent) {
        if (focusParent != null && focusParent != list) {
            focusParent.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.isShiftDown()) {
                        if (e.getKeyCode() == 40) {
                            list.dispatchEvent(e);
                            e.consume();
                        }
                        if (e.getKeyCode() == 38) {
                            list.dispatchEvent(e);
                            e.consume();
                        }
                    }
                }
            });
        }
    }

    public static void installMoveEndAction(final @NotNull JList<?> list, @Nullable JComponent focusParent) {
        new ListScrollAction(CommonShortcuts.getMoveEnd(), focusParent == null ? list : focusParent){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                ScrollingUtil.moveEnd(list);
            }
        };
    }

    public static void installMoveHomeAction(final @NotNull JList<?> list, @Nullable JComponent focusParent) {
        new ListScrollAction(CommonShortcuts.getMoveHome(), focusParent == null ? list : focusParent){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                ScrollingUtil.moveHome(list);
            }
        };
    }

    public static void installMovePageDownAction(final @NotNull JList<?> list, @Nullable JComponent focusParent) {
        new ListScrollAction(CommonShortcuts.getMovePageDown(), focusParent == null ? list : focusParent){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                ScrollingUtil.movePageDown(list);
            }
        };
    }

    public static void installMovePageUpAction(final @NotNull JList<?> list, @Nullable JComponent focusParent) {
        new ListScrollAction(CommonShortcuts.getMovePageUp(), focusParent == null ? list : focusParent){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                ScrollingUtil.movePageUp(list);
            }
        };
    }

    public static void installMoveDownAction(final @NotNull JList<?> list, @Nullable JComponent focusParent) {
        new ListScrollAction(CommonShortcuts.getMoveDown(), focusParent == null ? list : focusParent){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                ScrollingUtil.moveDown(list, 0);
            }
        };
    }

    public static void installMoveUpAction(final @NotNull JList<?> list, @Nullable JComponent focusParent) {
        new ListScrollAction(CommonShortcuts.getMoveUp(), focusParent == null ? list : focusParent){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                ScrollingUtil.moveUp(list, 0);
            }
        };
    }

    private static void maybeInstallDefaultShortcuts(@NotNull JComponent component) {
        InputMap map = component.getInputMap(0);
        UIUtil.maybeInstall((InputMap)map, (String)SCROLL_UP_ACTION_ID, (KeyStroke)KeyStroke.getKeyStroke(33, 0));
        UIUtil.maybeInstall((InputMap)map, (String)SCROLL_DOWN_ACTION_ID, (KeyStroke)KeyStroke.getKeyStroke(34, 0));
        UIUtil.maybeInstall((InputMap)map, (String)SELECT_PREVIOUS_ROW_ACTION_ID, (KeyStroke)KeyStroke.getKeyStroke(38, 0));
        UIUtil.maybeInstall((InputMap)map, (String)SELECT_NEXT_ROW_ACTION_ID, (KeyStroke)KeyStroke.getKeyStroke(40, 0));
        UIUtil.maybeInstall((InputMap)map, (String)SELECT_FIRST_ROW_ACTION_ID, (KeyStroke)KeyStroke.getKeyStroke(36, 0));
        UIUtil.maybeInstall((InputMap)map, (String)SELECT_LAST_ROW_ACTION_ID, (KeyStroke)KeyStroke.getKeyStroke(35, 0));
        UIUtil.maybeInstall((InputMap)map, (String)MOVE_HOME_ID, (KeyStroke)KeyStroke.getKeyStroke(37, 0));
        UIUtil.maybeInstall((InputMap)map, (String)MOVE_END_ID, (KeyStroke)KeyStroke.getKeyStroke(39, 0));
    }

    public static void ensureSelectionExists(@NotNull JTable table) {
        int size = table.getModel().getRowCount();
        if (size == 0) {
            table.clearSelection();
            return;
        }
        int selectedIndex = table.getSelectedRow();
        boolean reselect = false;
        if (selectedIndex < 0 || selectedIndex >= size) {
            selectedIndex = 0;
            reselect = true;
        }
        ScrollingUtil.ensureIndexIsVisible(table, selectedIndex, 0);
        if (reselect) {
            table.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
        }
    }

    @NotNull
    private static Rectangle getCellBounds(@NotNull JTable table, int top, int bottom) {
        return table.getCellRect(top, 0, true).union(table.getCellRect(bottom, 0, true));
    }

    private static int visibleRowCount(JComponent c) {
        if (c instanceof JList) {
            return ScrollingUtil.getVisibleRowCount((JList)c);
        }
        if (c instanceof JTable) {
            return ScrollingUtil.getVisibleRowCount((JTable)c);
        }
        return -1;
    }

    private static int getVisibleRowCount(@NotNull JTable table) {
        Rectangle visibleRect = table.getVisibleRect();
        return ScrollingUtil.getTrailingRow(table, visibleRect) - ScrollingUtil.getLeadingRow(table, visibleRect) + 1;
    }

    @NotNull
    public static Couple<Integer> getVisibleRows(@NotNull JTable table) {
        Rectangle visibleRect = table.getVisibleRect();
        return Couple.of((Object)ScrollingUtil.getLeadingRow(table, visibleRect), (Object)ScrollingUtil.getTrailingRow(table, visibleRect));
    }

    private static int getLeadingRow(@NotNull JTable table, @NotNull Rectangle visibleRect) {
        int row = table.rowAtPoint(ScrollingUtil.getLeadingPoint(table, visibleRect));
        if (row >= 0) {
            return row;
        }
        return 0 < table.getRowCount() ? 0 : -1;
    }

    @NotNull
    private static Point getLeadingPoint(@NotNull JTable table, @NotNull Rectangle visibleRect) {
        if (table.getComponentOrientation().isLeftToRight()) {
            return new Point(visibleRect.x, visibleRect.y);
        }
        return new Point(visibleRect.x + visibleRect.width, visibleRect.y);
    }

    public static int getReadableRow(@NotNull JTable table, int maximumHiddenPart) {
        int column;
        Rectangle visibleRect = table.getVisibleRect();
        Point leadingPoint = ScrollingUtil.getLeadingPoint(table, visibleRect);
        int row = table.rowAtPoint(leadingPoint);
        if ((double)leadingPoint.y - table.getCellRect(row, column = table.columnAtPoint(leadingPoint), true).getY() <= (double)maximumHiddenPart) {
            return row;
        }
        return Math.min(row + 1, table.getRowCount() - 1);
    }

    public static boolean isVisible(@NotNull JTable table, int row) {
        Rectangle visibleRect = table.getVisibleRect();
        int start = ScrollingUtil.getLeadingRow(table, visibleRect);
        int end = ScrollingUtil.getTrailingRow(table, visibleRect);
        return row >= start && row <= end;
    }

    private static int getTrailingRow(@NotNull JTable table, @NotNull Rectangle visibleRect) {
        Point trailingPoint = table.getComponentOrientation().isLeftToRight() ? new Point(visibleRect.x, visibleRect.y + visibleRect.height - 1) : new Point(visibleRect.x + visibleRect.width, visibleRect.y + visibleRect.height - 1);
        int row = table.rowAtPoint(trailingPoint);
        if (row >= 0) {
            return row;
        }
        return table.getRowCount() - 1;
    }

    public static void moveDown(@NotNull JTable table, @JdkConstants.InputEventMask int modifiers, boolean cycleScrolling) {
        ScrollingUtil._moveDown(table, table.getSelectionModel(), modifiers, table.getRowCount(), cycleScrolling);
    }

    public static void moveUp(@NotNull JList<?> list, @JdkConstants.InputEventMask int modifiers) {
        ScrollingUtil._moveUp(list, list.getSelectionModel(), list.getModel().getSize(), modifiers, UISettings.getInstance().getCycleScrolling());
    }

    public static void moveUp(@NotNull JTable table, @JdkConstants.InputEventMask int modifiers, boolean cycleScrolling) {
        ScrollingUtil._moveUp(table, table.getSelectionModel(), table.getModel().getRowCount(), modifiers, cycleScrolling);
    }

    private static void _moveDown(@NotNull JComponent c, @NotNull ListSelectionModel selectionModel, @JdkConstants.InputEventMask int modifiers, int size, boolean cycleScrolling) {
        ScrollingUtil._move(c, selectionModel, modifiers, size, cycleScrolling, 1);
    }

    private static void _move(@NotNull JComponent c, @NotNull ListSelectionModel selectionModel, @JdkConstants.InputEventMask int modifiers, int size, boolean cycleScrolling, int direction) {
        if (size == 0) {
            return;
        }
        int index = selectionModel.getLeadSelectionIndex();
        int indexToSelect = index + direction;
        if (indexToSelect < 0 || indexToSelect >= size) {
            if (cycleScrolling) {
                indexToSelect = indexToSelect < 0 ? size - 1 : 0;
            } else {
                return;
            }
        }
        ScrollingUtil._ensureIndexIsVisible(c, indexToSelect, -1, size);
        ScrollingUtil.selectOrAddSelection(selectionModel, indexToSelect, modifiers);
    }

    private static void _moveUp(@NotNull JComponent c, @NotNull ListSelectionModel selectionModel, int size, @JdkConstants.InputEventMask int modifiers, boolean cycleScrolling) {
        ScrollingUtil._move(c, selectionModel, modifiers, size, cycleScrolling, -1);
    }

    public static void moveHome(@NotNull JTable table) {
        table.getSelectionModel().setSelectionInterval(0, 0);
        ScrollingUtil.ensureIndexIsVisible(table, 0, 0);
    }

    public static void moveEnd(@NotNull JTable table) {
        int index = table.getModel().getRowCount() - 1;
        table.getSelectionModel().setSelectionInterval(index, index);
        ScrollingUtil.ensureIndexIsVisible(table, index, 0);
    }

    public static void movePageUp(@NotNull JTable table) {
        int visible = ScrollingUtil.getVisibleRowCount(table);
        if (visible <= 0) {
            ScrollingUtil.moveHome(table);
            return;
        }
        int step = visible - 1;
        ListSelectionModel selectionModel = table.getSelectionModel();
        int index = Math.max(selectionModel.getMinSelectionIndex() - step, 0);
        int visibleIndex = ScrollingUtil.getLeadingRow(table, table.getVisibleRect());
        int top = visibleIndex - step;
        if (top < 0) {
            top = 0;
        }
        int bottom = top + visible - 1;
        ScrollingUtil._scrollAfterPageMove(table, top, bottom, index);
    }

    public static void movePageDown(@NotNull JTable table) {
        int visible = ScrollingUtil.getVisibleRowCount(table);
        if (visible <= 0) {
            ScrollingUtil.moveEnd(table);
            return;
        }
        ListSelectionModel selectionModel = table.getSelectionModel();
        int step = visible - 1;
        int firstVisibleRow = ScrollingUtil.getLeadingRow(table, table.getVisibleRect());
        int top = firstVisibleRow + step;
        int bottom = top + visible - 1;
        int size = table.getModel().getRowCount();
        int index = Math.min(selectionModel.getMinSelectionIndex() + step, size - 1);
        ScrollingUtil._scrollAfterPageMove(table, top, bottom, index);
    }

    private static void _scrollAfterPageMove(@NotNull JTable table, int top, int bottom, int index) {
        int size = table.getModel().getRowCount();
        if (bottom >= size) {
            bottom = size - 1;
        }
        Rectangle cellBounds = ScrollingUtil.getCellBounds(table, top, bottom);
        table.scrollRectToVisible(cellBounds);
        table.getSelectionModel().setSelectionInterval(index, index);
        ScrollingUtil.ensureIndexIsVisible(table, index, 0);
    }

    public static void installActions(@NotNull JTable table) {
        ScrollingUtil.installActions(table, UISettings.getInstance().getCycleScrolling());
    }

    public static boolean isEmpty(JComponent component) {
        if (component instanceof JTable) {
            return ((JTable)component).getRowCount() < 1;
        }
        if (component instanceof JList) {
            return ((JList)component).getModel().getSize() < 1;
        }
        return false;
    }

    public static void installActions(@NotNull JTable table, boolean cycleScrolling) {
        ScrollingUtil.installActions(table, cycleScrolling, null);
    }

    public static void installActions(final @NotNull JTable table, final boolean cycleScrolling, @Nullable JComponent focusParent) {
        ActionMap actionMap = table.getActionMap();
        actionMap.put(SCROLL_UP_ACTION_ID, new MoveAction(SCROLL_UP_ACTION_ID, table, cycleScrolling));
        actionMap.put(SCROLL_DOWN_ACTION_ID, new MoveAction(SCROLL_DOWN_ACTION_ID, table, cycleScrolling));
        actionMap.put(SELECT_PREVIOUS_ROW_ACTION_ID, new MoveAction(SELECT_PREVIOUS_ROW_ACTION_ID, table, cycleScrolling));
        actionMap.put(SELECT_NEXT_ROW_ACTION_ID, new MoveAction(SELECT_NEXT_ROW_ACTION_ID, table, cycleScrolling));
        actionMap.put(SELECT_LAST_ROW_ACTION_ID, new MoveAction(SELECT_LAST_ROW_ACTION_ID, table, cycleScrolling));
        actionMap.put(SELECT_FIRST_ROW_ACTION_ID, new MoveAction(SELECT_FIRST_ROW_ACTION_ID, table, cycleScrolling));
        ScrollingUtil.maybeInstallDefaultShortcuts(table);
        final JComponent target = focusParent == null ? table : focusParent;
        new MyScrollingAction(table){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                ScrollingUtil.moveHome(table);
            }
        }.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(37, 0)), table);
        new MyScrollingAction(table){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                ScrollingUtil.moveEnd(table);
            }
        }.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(39, 0)), table);
        if (!(focusParent instanceof JTextComponent)) {
            new MyScrollingAction(table){

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    ScrollingUtil.moveHome(table);
                }
            }.registerCustomShortcutSet(CommonShortcuts.getMoveHome(), target);
            new MyScrollingAction(table){

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    ScrollingUtil.moveEnd(table);
                }
            }.registerCustomShortcutSet(CommonShortcuts.getMoveEnd(), target);
        }
        new MyScrollingAction(table){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                ScrollingUtil.moveDown(table, e.getModifiers(), cycleScrolling);
            }

            @Override
            protected boolean isEnabled() {
                return super.isEnabled() && !ScrollingUtil.isMultiline(target);
            }
        }.registerCustomShortcutSet(CommonShortcuts.getMoveDown(), target);
        new MyScrollingAction(table){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                ScrollingUtil.moveUp(table, e.getModifiers(), cycleScrolling);
            }

            @Override
            protected boolean isEnabled() {
                return super.isEnabled() && !ScrollingUtil.isMultiline(target);
            }
        }.registerCustomShortcutSet(CommonShortcuts.getMoveUp(), target);
        new MyScrollingAction(table){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                ScrollingUtil.movePageUp(table);
            }
        }.registerCustomShortcutSet(CommonShortcuts.getMovePageUp(), target);
        new MyScrollingAction(table){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                ScrollingUtil.movePageDown(table);
            }
        }.registerCustomShortcutSet(CommonShortcuts.getMovePageDown(), target);
    }

    private static boolean isMultiline(@NotNull JComponent component) {
        return component instanceof JTextArea && ((JTextArea)component).getText().contains("\n");
    }

    static class MoveAction
    extends AbstractAction {
        private final String myId;
        private final JComponent myComponent;
        private final Boolean myCycleScrolling;

        MoveAction(@NotNull String id, @NotNull JComponent component, @Nullable Boolean cycleScrolling) {
            this.myId = id;
            this.myComponent = component;
            this.myCycleScrolling = cycleScrolling;
        }

        MoveAction(@NotNull String id, @NotNull JComponent component) {
            this(id, component, null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int modifiers = e.getModifiers();
            if (ScrollingUtil.SCROLL_UP_ACTION_ID.equals(this.myId)) {
                this.doPageUp();
            } else if (ScrollingUtil.SCROLL_DOWN_ACTION_ID.equals(this.myId)) {
                this.doPageDown();
            } else if (ScrollingUtil.SELECT_PREVIOUS_ROW_ACTION_ID.equals(this.myId)) {
                this.doMoveUp(modifiers);
            } else if (ScrollingUtil.SELECT_NEXT_ROW_ACTION_ID.equals(this.myId)) {
                this.doMoveDown(modifiers);
            } else if (ScrollingUtil.SELECT_LAST_ROW_ACTION_ID.equals(this.myId)) {
                this.doMoveEnd();
            } else if (ScrollingUtil.SELECT_FIRST_ROW_ACTION_ID.equals(this.myId)) {
                this.doMoveHome();
            } else if (ScrollingUtil.MOVE_END_ID.equals(this.myId)) {
                this.doMoveEnd();
            } else if (ScrollingUtil.MOVE_HOME_ID.equals(this.myId)) {
                this.doMoveHome();
            }
        }

        private void doMoveEnd() {
            if (this.myComponent instanceof JList) {
                ScrollingUtil.moveEnd((JList)this.myComponent);
            } else if (this.myComponent instanceof JTable) {
                ScrollingUtil.moveEnd((JTable)this.myComponent);
            } else {
                throw new IllegalArgumentException("MoveEnd is not implemented for " + this.myComponent.getClass());
            }
        }

        private void doMoveHome() {
            if (this.myComponent instanceof JList) {
                ScrollingUtil.moveHome((JList)this.myComponent);
            } else if (this.myComponent instanceof JTable) {
                ScrollingUtil.moveHome((JTable)this.myComponent);
            } else {
                throw new IllegalArgumentException("MoveHome is not implemented for " + this.myComponent.getClass());
            }
        }

        private void doMoveUp(@JdkConstants.InputEventMask int modifiers) {
            if (this.myComponent instanceof JList) {
                ScrollingUtil.moveUp((JList)this.myComponent, modifiers);
            } else if (this.myComponent instanceof JTable) {
                ScrollingUtil.moveUp((JTable)this.myComponent, modifiers, this.isCycleScrolling());
            } else {
                throw new IllegalArgumentException("MoveUp is not implemented for " + this.myComponent.getClass());
            }
        }

        private void doMoveDown(@JdkConstants.InputEventMask int modifiers) {
            if (this.myComponent instanceof JList) {
                ScrollingUtil.moveDown((JList)this.myComponent, modifiers);
            } else if (this.myComponent instanceof JTable) {
                ScrollingUtil.moveDown((JTable)this.myComponent, modifiers, this.isCycleScrolling());
            } else {
                throw new IllegalArgumentException("MoveDown is not implemented for " + this.myComponent.getClass());
            }
        }

        private void doPageUp() {
            if (this.myComponent instanceof JList) {
                ScrollingUtil.movePageUp((JList)this.myComponent);
            } else if (this.myComponent instanceof JTable) {
                ScrollingUtil.movePageUp((JTable)this.myComponent);
            } else {
                throw new IllegalArgumentException("PageUp is not implemented for " + this.myComponent.getClass());
            }
        }

        private void doPageDown() {
            if (this.myComponent instanceof JList) {
                ScrollingUtil.movePageDown((JList)this.myComponent);
            } else if (this.myComponent instanceof JTable) {
                ScrollingUtil.movePageDown((JTable)this.myComponent);
            } else {
                throw new IllegalArgumentException("PageDown is not implemented for " + this.myComponent.getClass());
            }
        }

        private boolean isCycleScrolling() {
            return this.myCycleScrolling == null ? UISettings.getInstance().getCycleScrolling() : this.myCycleScrolling.booleanValue();
        }
    }

    private static abstract class MyScrollingAction
    extends DumbAwareAction
    implements ScrollingAction {
        private final JComponent myComponent;

        MyScrollingAction(@NotNull JComponent component) {
            this.myComponent = component;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabled(this.isEnabled());
        }

        protected boolean isEnabled() {
            return SpeedSearchSupply.getSupply(this.myComponent) == null && !ScrollingUtil.isEmpty(this.myComponent);
        }
    }

    public static abstract class ListScrollAction
    extends MyScrollingAction {
        protected ListScrollAction(@NotNull ShortcutSet shortcutSet, @NotNull JComponent component) {
            super(component);
            this.registerCustomShortcutSet(shortcutSet, component);
        }
    }

    public static interface ScrollingAction
    extends DumbAware {
    }
}

