/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.accessibility.AbstractAccessibleContextDelegate;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpandedItemRendererComponentWrapper
extends JComponent {
    JComponent owner;

    @Deprecated
    private ExpandedItemRendererComponentWrapper(final @NotNull Component rendererComponent) {
        this.add(rendererComponent);
        this.setOpaque(false);
        this.setLayout((LayoutManager)new AbstractLayoutManager(){

            public Dimension preferredLayoutSize(Container parent) {
                return rendererComponent.getPreferredSize();
            }

            public void layoutContainer(Container parent) {
                Dimension size = parent.getSize();
                if (ExpandedItemRendererComponentWrapper.this.owner != null) {
                    Rectangle visible = ExpandedItemRendererComponentWrapper.this.owner.getVisibleRect();
                    size.width = visible.x + visible.width;
                }
                Insets i = parent.getInsets();
                Dimension pref = rendererComponent.getPreferredSize();
                rendererComponent.setBounds(i.left, i.top, Math.max(pref.width, size.width - i.left - i.right), size.height - i.top - i.bottom);
            }
        });
    }

    private ExpandedItemRendererComponentWrapper() {
    }

    @NotNull
    public static ExpandedItemRendererComponentWrapper wrap(@NotNull Component rendererComponent) {
        if (rendererComponent instanceof Accessible) {
            return new MyComponent(rendererComponent, (Accessible)((Object)rendererComponent));
        }
        return new ExpandedItemRendererComponentWrapper(rendererComponent);
    }

    @NotNull
    public static Component unwrap(@NotNull Component rendererComponent) {
        if (rendererComponent instanceof ExpandedItemRendererComponentWrapper) {
            Component component = ((ExpandedItemRendererComponentWrapper)rendererComponent).getDelegate();
            return component;
        }
        return rendererComponent;
    }

    @Override
    public void setBorder(Border border) {
        Component c = this.getDelegate();
        if (c instanceof JComponent) {
            ((JComponent)c).setBorder(border);
            return;
        }
        super.setBorder(border);
    }

    @Override
    public String getToolTipText() {
        Component c = this.getDelegate();
        if (c instanceof JComponent) {
            return ((JComponent)c).getToolTipText();
        }
        return super.getToolTipText();
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Component c = this.getDelegate();
        if (c instanceof JComponent) {
            return ((JComponent)c).getToolTipText(event);
        }
        return super.getToolTipText(event);
    }

    @Override
    public Point getToolTipLocation(MouseEvent event) {
        Component c = this.getDelegate();
        if (c instanceof JComponent) {
            return ((JComponent)c).getToolTipLocation(event);
        }
        return super.getToolTipLocation(event);
    }

    @Nullable
    private Component getDelegate() {
        if (this.getComponentCount() == 1) {
            return this.getComponent(0);
        }
        return null;
    }

    private static class MyComponent
    extends ExpandedItemRendererComponentWrapper
    implements Accessible {
        private final Accessible myAccessible;
        private AccessibleContext myDefaultAccessibleContext;

        MyComponent(@NotNull Component comp, @NotNull Accessible accessible) {
            super(comp);
            this.myAccessible = accessible;
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleMyComponent();
            }
            return this.accessibleContext;
        }

        public AccessibleContext getDefaultAccessibleContext() {
            if (this.myDefaultAccessibleContext == null) {
                this.myDefaultAccessibleContext = new JComponent.AccessibleJComponent(){};
            }
            return this.myDefaultAccessibleContext;
        }

        protected class AccessibleMyComponent
        extends AbstractAccessibleContextDelegate {
            protected AccessibleMyComponent() {
            }

            @NotNull
            protected AccessibleContext getDelegate() {
                return MyComponent.this.myAccessible.getAccessibleContext();
            }

            public Accessible getAccessibleParent() {
                return MyComponent.this.getDefaultAccessibleContext().getAccessibleParent();
            }

            public int getAccessibleIndexInParent() {
                return MyComponent.this.getDefaultAccessibleContext().getAccessibleIndexInParent();
            }
        }
    }
}

