/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.task;

import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.ProjectTaskResult;
import com.intellij.util.messages.Topic;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface ProjectTaskListener {
    public static final Topic<ProjectTaskListener> TOPIC = new Topic("project task events", ProjectTaskListener.class);

    default public void started(@NotNull ProjectTaskContext context) {
    }

    default public void finished(@NotNull ProjectTaskManager.Result result) {
        this.finished(result.getContext(), new ProjectTaskResult(result.isAborted(), result.hasErrors() ? 1 : 0, 0));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    default public void finished(@NotNull ProjectTaskContext context, @NotNull ProjectTaskResult executionResult) {
    }
}

