/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.RefactoringMessageDialog;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommonRefactoringUtil {
    private CommonRefactoringUtil() {
    }

    public static void showErrorMessage(@NlsContexts.DialogTitle String title, @NlsContexts.DialogMessage String message, @NonNls @Nullable String helpId, @NotNull Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException(message);
        }
        RefactoringMessageDialog dialog = new RefactoringMessageDialog(title, message, helpId, "OptionPane.errorIcon", false, project);
        dialog.show();
    }

    public static void sortDepthFirstRightLeftOrder(UsageInfo[] usages) {
        Arrays.sort(usages, (usage1, usage2) -> {
            PsiElement element2;
            PsiElement element1 = usage1.getElement();
            if (element1 == (element2 = usage2.getElement())) {
                return 0;
            }
            if (element1 == null) {
                return 1;
            }
            if (element2 == null) {
                return -1;
            }
            return element2.getTextRange().getStartOffset() - element1.getTextRange().getStartOffset();
        });
    }

    public static void showErrorHint(@NotNull Project project, @Nullable Editor editor, @NotNull @NlsContexts.DialogMessage String message, @NotNull @NlsContexts.DialogTitle String title, @Nullable String helpId) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RefactoringErrorHintException(message);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (editor == null || editor.getComponent().getRootPane() == null) {
                CommonRefactoringUtil.showErrorMessage(title, message, helpId, project);
            } else {
                HintManager.getInstance().showErrorHint(editor, message);
            }
        });
    }

    public static String htmlEmphasize(@NotNull String text) {
        return StringUtil.htmlEmphasize((String)text);
    }

    public static boolean checkReadOnlyStatus(@NotNull PsiElement element) {
        VirtualFile file = element.getContainingFile().getVirtualFile();
        return file != null && !ReadonlyStatusHandler.getInstance(element.getProject()).ensureFilesWritable(Collections.singletonList(file)).hasReadonlyFiles();
    }

    public static boolean checkReadOnlyStatus(@NotNull Project project, @NotNull PsiElement element) {
        return CommonRefactoringUtil.checkReadOnlyStatus(element, project, RefactoringBundle.message("refactoring.cannot.be.performed"));
    }

    public static boolean checkReadOnlyStatus(@NotNull Project project, PsiElement ... elements) {
        return CommonRefactoringUtil.checkReadOnlyStatus(project, Collections.emptySet(), Arrays.asList(elements), RefactoringBundle.message("refactoring.cannot.be.performed"), true);
    }

    public static boolean checkReadOnlyStatus(@NotNull Project project, @NotNull Collection<? extends PsiElement> elements, boolean notifyOnFail) {
        return CommonRefactoringUtil.checkReadOnlyStatus(project, Collections.emptySet(), elements, RefactoringBundle.message("refactoring.cannot.be.performed"), notifyOnFail);
    }

    public static boolean checkReadOnlyStatus(@NotNull PsiElement element, @NotNull Project project, @NotNull String messagePrefix) {
        return element.isWritable() || CommonRefactoringUtil.checkReadOnlyStatus(project, Collections.emptySet(), Collections.singleton(element), messagePrefix, true);
    }

    public static boolean checkReadOnlyStatusRecursively(@NotNull Project project, @NotNull Collection<? extends PsiElement> elements) {
        return CommonRefactoringUtil.checkReadOnlyStatus(project, elements, Collections.emptySet(), RefactoringBundle.message("refactoring.cannot.be.performed"), false);
    }

    public static boolean checkReadOnlyStatusRecursively(@NotNull Project project, @NotNull Collection<? extends PsiElement> elements, boolean notifyOnFail) {
        return CommonRefactoringUtil.checkReadOnlyStatus(project, elements, Collections.emptySet(), RefactoringBundle.message("refactoring.cannot.be.performed"), notifyOnFail);
    }

    public static boolean checkReadOnlyStatus(@NotNull Project project, @NotNull Collection<? extends PsiElement> recursive, @NotNull Collection<? extends PsiElement> flat, boolean notifyOnFail) {
        return CommonRefactoringUtil.checkReadOnlyStatus(project, recursive, flat, RefactoringBundle.message("refactoring.cannot.be.performed"), notifyOnFail);
    }

    private static boolean checkReadOnlyStatus(@NotNull Project project, @NotNull Collection<? extends PsiElement> recursive, @NotNull Collection<? extends PsiElement> flat, @NotNull String messagePrefix, boolean notifyOnFail) {
        THashSet readonly = new THashSet();
        THashSet failed = new THashSet();
        boolean seenNonWritablePsiFilesWithoutVirtualFile = CommonRefactoringUtil.checkReadOnlyStatus(flat, false, (Collection<? super VirtualFile>)readonly, (Collection<? super VirtualFile>)failed) || CommonRefactoringUtil.checkReadOnlyStatus(recursive, true, (Collection<? super VirtualFile>)readonly, (Collection<? super VirtualFile>)failed);
        ReadonlyStatusHandler.OperationStatus status = ReadonlyStatusHandler.getInstance(project).ensureFilesWritable((Collection<? extends VirtualFile>)readonly);
        ContainerUtil.addAll((Collection)failed, (Object[])status.getReadonlyFiles());
        if (notifyOnFail && (!failed.isEmpty() || seenNonWritablePsiFilesWithoutVirtualFile && readonly.isEmpty())) {
            StringBuilder message = new StringBuilder(messagePrefix).append('\n');
            int i = 0;
            for (VirtualFile virtualFile2 : failed) {
                String subj = RefactoringBundle.message(virtualFile2.isDirectory() ? "directory.description" : "file.description", virtualFile2.getPresentableUrl());
                if (virtualFile2.getFileSystem().isReadOnly()) {
                    message.append(RefactoringBundle.message("0.is.located.in.a.jar.file", subj)).append('\n');
                } else {
                    message.append(RefactoringBundle.message("0.is.read.only", subj)).append('\n');
                }
                if (i++ <= 20) continue;
                message.append("...\n");
                break;
            }
            CommonRefactoringUtil.showErrorMessage(RefactoringBundle.message("error.title"), message.toString(), null, project);
            return false;
        }
        return failed.isEmpty();
    }

    private static boolean checkReadOnlyStatus(Collection<? extends PsiElement> elements, boolean recursively, Collection<? super VirtualFile> readonly, Collection<? super VirtualFile> failed) {
        boolean seenNonWritablePsiFilesWithoutVirtualFile = false;
        for (PsiElement psiElement : elements) {
            if (psiElement instanceof PsiDirectory) {
                PsiDirectory dir = (PsiDirectory)psiElement;
                VirtualFile virtualFile2 = dir.getVirtualFile();
                if (virtualFile2.getFileSystem().isReadOnly()) {
                    failed.add(virtualFile2);
                    continue;
                }
                if (recursively) {
                    CommonRefactoringUtil.collectReadOnlyFiles(virtualFile2, readonly);
                    continue;
                }
                readonly.add(virtualFile2);
                continue;
            }
            if (psiElement instanceof PsiDirectoryContainer) {
                PsiDirectory[] directories;
                for (PsiDirectory directory : directories = ((PsiDirectoryContainer)psiElement).getDirectories()) {
                    VirtualFile virtualFile2 = directory.getVirtualFile();
                    if (recursively) {
                        if (virtualFile2.getFileSystem().isReadOnly()) {
                            failed.add(virtualFile2);
                            continue;
                        }
                        CommonRefactoringUtil.collectReadOnlyFiles(virtualFile2, readonly);
                        continue;
                    }
                    if (virtualFile2.getFileSystem().isReadOnly()) {
                        failed.add(virtualFile2);
                        continue;
                    }
                    readonly.add(virtualFile2);
                }
                continue;
            }
            PsiFile file = psiElement.getContainingFile();
            if (file == null) {
                if (psiElement.isWritable()) continue;
                seenNonWritablePsiFilesWithoutVirtualFile = true;
                continue;
            }
            VirtualFile virtualFile3 = file.getVirtualFile();
            if (virtualFile3 != null) {
                readonly.add(virtualFile3);
                continue;
            }
            if (psiElement.isWritable()) continue;
            seenNonWritablePsiFilesWithoutVirtualFile = true;
        }
        return seenNonWritablePsiFilesWithoutVirtualFile;
    }

    public static void collectReadOnlyFiles(@NotNull VirtualFile vFile, final @NotNull Collection<? super VirtualFile> list) {
        final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        VfsUtilCore.visitChildrenRecursively(vFile, new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS}){

            @Override
            public boolean visitFile(@NotNull VirtualFile file) {
                boolean ignored = fileTypeManager.isFileIgnored(file);
                if (!file.isWritable() && !ignored) {
                    list.add(file);
                }
                return !ignored;
            }
        });
    }

    public static String capitalize(@NotNull String text) {
        return StringUtil.capitalize((String)text);
    }

    public static boolean isAncestor(@NotNull PsiElement resolved, @NotNull Collection<? extends PsiElement> scopes) {
        for (PsiElement psiElement : scopes) {
            if (!PsiTreeUtil.isAncestor(psiElement, resolved, false)) continue;
            return true;
        }
        return false;
    }

    public static class RefactoringErrorHintException
    extends RuntimeException {
        public RefactoringErrorHintException(String message) {
            super(message);
        }
    }
}

