/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiFileWithOneLanguage;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiUtilBase
extends PsiUtilCore
implements PsiEditorUtil {
    private static final Logger LOG = Logger.getInstance(PsiUtilBase.class);
    public static final Comparator<Language> LANGUAGE_COMPARATOR = Comparator.comparing(Language::getID);

    public static boolean isUnderPsiRoot(@NotNull PsiFile root, @NotNull PsiElement element) {
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == root) {
            return true;
        }
        for (PsiFile psiRoot : root.getViewProvider().getAllFiles()) {
            if (containingFile != psiRoot) continue;
            return true;
        }
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance(root.getProject()).getInjectionHost(element);
        return host != null && PsiUtilBase.isUnderPsiRoot(root, host);
    }

    @Nullable
    public static Language getLanguageInEditor(@NotNull Editor editor, @NotNull Project project) {
        return PsiUtilBase.getLanguageInEditor(editor.getCaretModel().getCurrentCaret(), project);
    }

    @Nullable
    public static Language getLanguageInEditor(@NotNull Caret caret, @NotNull Project project) {
        Editor editor = caret.getEditor();
        PsiFile file = PsiDocumentManager.getInstance(project).getPsiFile(editor.getDocument());
        if (file == null) {
            return null;
        }
        if (file instanceof PsiFileWithOneLanguage) {
            return file.getLanguage();
        }
        int caretOffset = caret.getOffset();
        int mostProbablyCorrectLanguageOffset = caretOffset == caret.getSelectionEnd() ? caret.getSelectionStart() : caretOffset;
        PsiElement elt = PsiUtilBase.getElementAtOffset(file, mostProbablyCorrectLanguageOffset);
        Language lang = PsiUtilBase.findLanguageFromElement(elt);
        if (caret.hasSelection()) {
            lang = PsiUtilBase.evaluateLanguageInRange(caret.getSelectionStart(), caret.getSelectionEnd(), file);
        }
        return PsiUtilBase.narrowLanguage(lang, file.getLanguage());
    }

    @Nullable
    public static PsiElement getElementAtCaret(@NotNull Editor editor) {
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        PsiFile file = PsiDocumentManager.getInstance(project).getPsiFile(editor.getDocument());
        return file == null ? null : file.findElementAt(editor.getCaretModel().getOffset());
    }

    @Nullable
    public static PsiFile getPsiFileInEditor(@NotNull Editor editor, @NotNull Project project) {
        return PsiUtilBase.getPsiFileInEditor(editor.getCaretModel().getCurrentCaret(), project);
    }

    @Nullable
    public static PsiFile getPsiFileInEditor(@NotNull Caret caret, @NotNull Project project) {
        Editor editor = caret.getEditor();
        PsiFile file = PsiDocumentManager.getInstance(project).getPsiFile(editor.getDocument());
        if (file == null) {
            return null;
        }
        PsiUtilCore.ensureValid(file);
        if (file instanceof PsiFileWithOneLanguage) {
            return file;
        }
        Language language = PsiUtilBase.getLanguageInEditor(caret, project);
        if (language == file.getLanguage()) {
            return file;
        }
        int caretOffset = caret.getOffset();
        int mostProbablyCorrectLanguageOffset = caretOffset == caret.getSelectionEnd() ? caret.getSelectionStart() : caretOffset;
        return PsiUtilBase.getPsiFileAtOffset(file, mostProbablyCorrectLanguageOffset);
    }

    public static PsiFile getPsiFileAtOffset(@NotNull PsiFile file, int offset) {
        if (file instanceof PsiFileWithOneLanguage) {
            return file;
        }
        PsiElement elt = PsiUtilBase.getElementAtOffset(file, offset);
        PsiUtilBase.ensureValid(elt);
        return elt.getContainingFile();
    }

    @Nullable
    public static Language reallyEvaluateLanguageInRange(int start, int end, @NotNull PsiFile file) {
        TextRange range;
        int endOffset;
        if (file instanceof PsiBinaryFile || file instanceof PsiFileWithOneLanguage) {
            return file.getLanguage();
        }
        Language lang = null;
        int curOffset = start;
        do {
            PsiElement elt;
            if (!((elt = PsiUtilBase.getElementAtOffset(file, curOffset)) instanceof PsiWhiteSpace)) {
                Language language = PsiUtilBase.findLanguageFromElement(elt);
                if (lang == null) {
                    lang = language;
                } else if (lang != language) {
                    return null;
                }
            }
            if ((range = elt.getTextRange()) != null) continue;
            LOG.error("Null range for element " + elt + " of " + elt.getClass() + " in file " + file + " at offset " + curOffset);
            return file.getLanguage();
        } while ((curOffset = (endOffset = range.getEndOffset()) <= curOffset ? curOffset + 1 : endOffset) < end);
        return PsiUtilBase.narrowLanguage(lang, file.getLanguage());
    }

    @NotNull
    private static Language evaluateLanguageInRange(int start, int end, @NotNull PsiFile file) {
        PsiElement elt = PsiUtilBase.getElementAtOffset(file, start);
        TextRange selectionRange = new TextRange(start, end);
        while (!(elt instanceof PsiFile)) {
            PsiElement parent = elt.getParent();
            TextRange range = elt.getTextRange();
            if (range == null) {
                LOG.error("Range is null for " + elt + "; " + elt.getClass());
                return file.getLanguage();
            }
            if (range.contains(selectionRange) || parent == null) {
                return elt.getLanguage();
            }
            elt = parent;
        }
        return elt.getLanguage();
    }

    @NotNull
    public static ASTNode getRoot(@NotNull ASTNode node) {
        ASTNode child = node;
        ASTNode parent;
        while ((parent = child.getTreeParent()) != null) {
            child = parent;
        }
        return child;
    }

    @Override
    @Deprecated
    @Nullable
    public Editor findEditorByPsiElement(@NotNull PsiElement element) {
        return PsiUtilBase.findEditor(element);
    }

    @Deprecated
    @Nullable
    public static Editor findEditor(@NotNull PsiElement element) {
        return PsiEditorUtil.findEditor(element);
    }

    public static boolean isSymLink(@NotNull PsiFileSystemItem element) {
        VirtualFile virtualFile2 = element.getVirtualFile();
        return virtualFile2 != null && virtualFile2.is(VFileProperty.SYMLINK);
    }

    @Nullable
    public static VirtualFile asVirtualFile(@Nullable PsiElement element) {
        if (element instanceof PsiFileSystemItem) {
            PsiFileSystemItem psiFileSystemItem = (PsiFileSystemItem)element;
            return psiFileSystemItem.isValid() ? psiFileSystemItem.getVirtualFile() : null;
        }
        return null;
    }
}

