/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CachedValuesManager {
    private static final NotNullLazyKey<CachedValuesManager, Project> INSTANCE_KEY = ServiceManager.createLazyKey(CachedValuesManager.class);
    private final ConcurrentMap<String, Key<CachedValue>> keyForProvider = new ConcurrentHashMap<String, Key<CachedValue>>();
    private static final ConcurrentMap<String, Key<CachedValue>> globalKeyForProvider = new ConcurrentHashMap<String, Key<CachedValue>>();

    public static CachedValuesManager getManager(@NotNull Project project) {
        return (CachedValuesManager)INSTANCE_KEY.getValue((UserDataHolder)project);
    }

    @NotNull
    public abstract <T> CachedValue<T> createCachedValue(@NotNull CachedValueProvider<T> var1, boolean var2);

    @NotNull
    public abstract <T, P> ParameterizedCachedValue<T, P> createParameterizedCachedValue(@NotNull ParameterizedCachedValueProvider<T, P> var1, boolean var2);

    @NotNull
    public <T> CachedValue<T> createCachedValue(@NotNull CachedValueProvider<T> provider) {
        return this.createCachedValue(provider, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, P> T getParameterizedCachedValue(@NotNull UserDataHolder dataHolder, @NotNull Key<ParameterizedCachedValue<T, P>> key, @NotNull ParameterizedCachedValueProvider<T, P> provider, boolean trackValue, P parameter) {
        ParameterizedCachedValue value;
        if (dataHolder instanceof UserDataHolderEx) {
            UserDataHolderEx dh = (UserDataHolderEx)dataHolder;
            value = (ParameterizedCachedValue)dh.getUserData(key);
            if (value == null) {
                this.trackKeyHolder(dataHolder, key);
                value = this.createParameterizedCachedValue(provider, trackValue);
                value = (ParameterizedCachedValue)dh.putUserDataIfAbsent(key, value);
            }
        } else {
            UserDataHolder userDataHolder = dataHolder;
            synchronized (userDataHolder) {
                value = (ParameterizedCachedValue)dataHolder.getUserData(key);
                if (value == null) {
                    this.trackKeyHolder(dataHolder, key);
                    value = this.createParameterizedCachedValue(provider, trackValue);
                    dataHolder.putUserData(key, (Object)value);
                }
            }
        }
        return value.getValue(parameter);
    }

    @ApiStatus.Internal
    protected abstract void trackKeyHolder(@NotNull UserDataHolder var1, @NotNull Key<?> var2);

    public abstract <T> T getCachedValue(@NotNull UserDataHolder var1, @NotNull Key<CachedValue<T>> var2, @NotNull CachedValueProvider<T> var3, boolean var4);

    public <T> T getCachedValue(@NotNull UserDataHolder dataHolder, @NotNull CachedValueProvider<T> provider) {
        return this.getCachedValue(dataHolder, this.getKeyForClass(provider.getClass()), provider, false);
    }

    public static <T> T getCachedValue(@NotNull PsiElement context, @NotNull CachedValueProvider<T> provider) {
        return CachedValuesManager.getCachedValue(context, CachedValuesManager.getKeyForClass(provider.getClass(), globalKeyForProvider), provider);
    }

    public static <E extends PsiElement, T> T getProjectPsiDependentCache(@NotNull E context, @NotNull Function<? super E, ? extends T> provider) {
        return CachedValuesManager.getCachedValue(context, CachedValuesManager.getKeyForClass(provider.getClass(), globalKeyForProvider), () -> CachedValueProvider.Result.create(provider.apply(context), PsiModificationTracker.MODIFICATION_COUNT));
    }

    public static <T> T getCachedValue(final @NotNull PsiElement context, @NotNull Key<CachedValue<T>> key, final @NotNull CachedValueProvider<T> provider) {
        Getter data;
        CachedValue value = (CachedValue)context.getUserData(key);
        if (value != null && (data = value.getUpToDateOrNull()) != null) {
            return (T)data.get();
        }
        return CachedValuesManager.getManager(context.getProject()).getCachedValue(context, key, new CachedValueProvider<T>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<T> compute() {
                PsiFile file;
                CachedValueProvider.Result result = provider.compute();
                if (result != null && !context.isPhysical() && (file = context.getContainingFile()) != null) {
                    return CachedValueProvider.Result.create(result.getValue(), ArrayUtil.append((Object[])result.getDependencyItems(), (Object)file, (ArrayFactory)ArrayUtil.OBJECT_ARRAY_FACTORY));
                }
                return result;
            }

            public String toString() {
                return provider.toString();
            }
        }, false);
    }

    @NotNull
    public <T> Key<CachedValue<T>> getKeyForClass(@NotNull Class<?> providerClass) {
        return CachedValuesManager.getKeyForClass(providerClass, this.keyForProvider);
    }

    @NotNull
    private static <T> Key<CachedValue<T>> getKeyForClass(@NotNull Class<?> providerClass, ConcurrentMap<String, Key<CachedValue>> keyForProvider) {
        String name = providerClass.getName();
        Key key = (Key)keyForProvider.get(name);
        if (key == null) {
            key = (Key)ConcurrencyUtil.cacheOrGet(keyForProvider, (Object)name, (Object)Key.create((String)name));
        }
        return key;
    }
}

