/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.ProfilingInfo;
import com.intellij.util.containers.MultiMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CachedValueProfiler {
    private static final CachedValueProfiler ourInstance = new CachedValueProfiler();
    private volatile MultiMap<StackTraceElement, ProfilingInfo> myStorage = null;
    private final Object myLock = new Object();
    private volatile ConcurrentMap<CachedValueProvider.Result<?>, ProfilingInfo> myTemporaryResults;

    public static boolean canProfile() {
        return ApplicationManager.getApplication().isInternal();
    }

    public boolean isEnabled() {
        return this.myStorage != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean value) {
        Object object = this.myLock;
        synchronized (object) {
            if (value) {
                MultiMap<StackTraceElement, ProfilingInfo> storage = this.myStorage;
                if (storage == null) {
                    this.myStorage = MultiMap.createConcurrent();
                }
                this.myTemporaryResults = new ConcurrentHashMap();
            } else {
                this.myStorage = null;
                this.myTemporaryResults = null;
            }
        }
    }

    @NotNull
    public static CachedValueProfiler getInstance() {
        return ourInstance;
    }

    public void createInfo(@NotNull CachedValueProvider.Result<?> result) {
        MultiMap<StackTraceElement, ProfilingInfo> storage = this.myStorage;
        if (storage == null) {
            return;
        }
        ConcurrentMap<CachedValueProvider.Result<?>, ProfilingInfo> temporaryResults = this.myTemporaryResults;
        if (temporaryResults == null) {
            return;
        }
        StackTraceElement origin = CachedValueProfiler.findOrigin();
        if (origin == null) {
            return;
        }
        ProfilingInfo info = new ProfilingInfo(origin);
        storage.putValue((Object)origin, (Object)info);
        temporaryResults.put(result, info);
    }

    @Nullable
    public <T> ProfilingInfo getTemporaryInfo(@NotNull CachedValueProvider.Result<T> result) {
        ConcurrentMap<CachedValueProvider.Result<?>, ProfilingInfo> map = this.myTemporaryResults;
        return map != null ? (ProfilingInfo)map.remove(result) : null;
    }

    public MultiMap<StackTraceElement, ProfilingInfo> getStorageSnapshot() {
        return this.myStorage.copy();
    }

    @Nullable
    private static StackTraceElement findOrigin() {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        return CachedValueProfiler.findFirstStackTraceElementExcluding(stackTrace, CachedValueProfiler.class.getName(), CachedValueProvider.class.getName());
    }

    @Nullable
    private static StackTraceElement findFirstStackTraceElementExcluding(StackTraceElement @NotNull [] stackTraceElements, String ... excludedClasses) {
        for (StackTraceElement element : stackTraceElements) {
            if (CachedValueProfiler.matches(element, excludedClasses)) continue;
            return element;
        }
        return null;
    }

    private static boolean matches(@NotNull StackTraceElement element, String @NotNull [] excludedClasses) {
        for (String aClass : excludedClasses) {
            if (!element.getClassName().startsWith(aClass)) continue;
            return true;
        }
        return false;
    }
}

