/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.tree;

import com.intellij.diagnostic.LoadingState;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IElementType {
    private static final Logger LOG = Logger.getInstance(IElementType.class);
    public static final IElementType[] EMPTY_ARRAY = new IElementType[0];
    public static final ArrayFactory<IElementType> ARRAY_FACTORY = count -> count == 0 ? EMPTY_ARRAY : new IElementType[count];
    public static final Predicate TRUE = type -> true;
    public static final short FIRST_TOKEN_INDEX = 1;
    private static final short MAX_INDEXED_TYPES = 15000;
    private static short size;
    private static volatile IElementType @NotNull [] ourRegistry;
    @NonNls
    private static final Object lock;
    private final short myIndex;
    @NonNls
    @NotNull
    private final String myDebugName;
    @NotNull
    private final Language myLanguage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IElementType @NotNull [] push(IElementType @NotNull [] types) {
        Object object = lock;
        synchronized (object) {
            IElementType[] oldRegistry = ourRegistry;
            ourRegistry = types;
            size = (short)ContainerUtil.skipNulls(Arrays.asList(ourRegistry)).size();
            return oldRegistry;
        }
    }

    public static void unregisterElementTypes(@NotNull ClassLoader loader) {
        for (int i = 0; i < ourRegistry.length; ++i) {
            IElementType type = ourRegistry[i];
            if (type == null || type.getClass().getClassLoader() != loader) continue;
            IElementType.ourRegistry[i] = new TombstoneElementType("tombstone of " + type.myDebugName);
        }
    }

    public static void unregisterElementTypes(@NotNull Language language) {
        if (language == Language.ANY) {
            throw new IllegalArgumentException("Trying to unregister Language.ANY");
        }
        for (int i = 0; i < ourRegistry.length; ++i) {
            IElementType type = ourRegistry[i];
            if (type == null || !((Object)((Object)type.getLanguage())).equals((Object)language)) continue;
            IElementType.ourRegistry[i] = new TombstoneElementType("tombstone of " + type.myDebugName);
        }
    }

    public IElementType(@NonNls @NotNull String debugName, @Nullable Language language) {
        this(debugName, language, true);
        if (!(this instanceof IFileElementType)) {
            LoadingState.COMPONENTS_LOADED.checkOccurred();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IElementType(@NonNls @NotNull String debugName, @Nullable Language language, boolean register2) {
        this.myDebugName = debugName;
        Language language2 = this.myLanguage = language == null ? Language.ANY : language;
        if (register2) {
            Object object = lock;
            synchronized (object) {
                short s = size;
                size = (short)(s + 1);
                this.myIndex = s;
                if (this.myIndex >= 15000) {
                    Map<Language, List<IElementType>> byLang = Stream.of(ourRegistry).filter(Objects::nonNull).collect(Collectors.groupingBy(ie -> ie.myLanguage));
                    Map.Entry max = byLang.entrySet().stream().max(Comparator.comparingInt(e -> ((List)e.getValue()).size())).get();
                    List types = (List)max.getValue();
                    LOG.error("Too many element types registered. Out of (short) range. Most of element types (" + types.size() + ") were registered for '" + max.getKey() + "': " + StringUtil.first((String)StringUtil.join((Iterable)types, (String)", "), (int)300, (boolean)true));
                }
                IElementType[] newRegistry = this.myIndex >= ourRegistry.length ? (IElementType[])ArrayUtil.realloc((Object[])ourRegistry, (int)(ourRegistry.length * 3 / 2 + 1), ARRAY_FACTORY) : ourRegistry;
                newRegistry[this.myIndex] = this;
                ourRegistry = newRegistry;
            }
        } else {
            this.myIndex = (short)-1;
        }
    }

    @NotNull
    public Language getLanguage() {
        return this.myLanguage;
    }

    public final short getIndex() {
        return this.myIndex;
    }

    public int hashCode() {
        return this.myIndex >= 0 ? this.myIndex : super.hashCode();
    }

    public String toString() {
        return this.myDebugName;
    }

    public boolean isLeftBound() {
        return false;
    }

    public static IElementType find(short idx) {
        IElementType type = ourRegistry[idx];
        if (type instanceof TombstoneElementType) {
            throw new IllegalArgumentException("Trying to access element type from unloaded plugin: " + type.myDebugName);
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static short getAllocatedTypesCount() {
        Object object = lock;
        synchronized (object) {
            return size;
        }
    }

    public static IElementType @NotNull [] enumerate(@NotNull Predicate p) {
        ArrayList<IElementType> matches = new ArrayList<IElementType>();
        for (IElementType value : ourRegistry) {
            if (value == null || !p.matches(value)) continue;
            matches.add(value);
        }
        return matches.toArray(new IElementType[0]);
    }

    static {
        ourRegistry = EMPTY_ARRAY;
        lock = new String("registry lock");
        IElementType[] init = new IElementType[137];
        init[0] = new IElementType("NULL", Language.ANY, false);
        IElementType.push(init);
    }

    public static class TombstoneElementType
    extends IElementType {
        public TombstoneElementType(@NotNull String debugName) {
            super(debugName, Language.ANY);
        }
    }

    @FunctionalInterface
    public static interface Predicate {
        public boolean matches(@NotNull IElementType var1);
    }
}

