/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.packageSet.CompoundPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.util.containers.ContainerUtil;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntersectionPackageSet
extends CompoundPackageSet {
    @NotNull
    public static PackageSet create(PackageSet ... sets) {
        if (sets.length == 0) {
            throw new IllegalArgumentException("empty arguments");
        }
        return sets.length == 1 ? sets[0] : new IntersectionPackageSet(sets);
    }

    private IntersectionPackageSet(PackageSet ... sets) {
        super(sets);
    }

    @Override
    public boolean contains(@NotNull VirtualFile file, @NotNull Project project, @Nullable NamedScopesHolder holder) {
        PsiFile psiFile = null;
        for (PackageSet set : this.mySets) {
            if (set instanceof PackageSetBase) {
                if (((PackageSetBase)set).contains(file, project, holder)) continue;
                return false;
            }
            if (psiFile == null) {
                psiFile = IntersectionPackageSet.getPsiFile(file, project);
            }
            if (set.contains(psiFile, holder)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getNodePriority() {
        return 2;
    }

    @Override
    public PackageSet map(@NotNull Function<? super PackageSet, ? extends PackageSet> transformation) {
        return IntersectionPackageSet.create((PackageSet[])ContainerUtil.map((Object[])this.mySets, s -> (PackageSet)transformation.apply((PackageSet)s), (Object[])new PackageSet[this.mySets.length]));
    }

    @Override
    @NotNull
    public String getText() {
        if (this.myText == null) {
            this.myText = StringUtil.join((Object[])this.mySets, set -> {
                boolean needParen = set.getNodePriority() > this.getNodePriority();
                return (needParen ? "(" : "") + set.getText() + (needParen ? ")" : "");
            }, (String)"&&");
        }
        return this.myText;
    }
}

