/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.FilteredPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.ui.IconManager;
import org.jetbrains.annotations.NotNull;

public final class TestsScope
extends NamedScope {
    public static final String NAME = "Tests";
    public static final TestsScope INSTANCE = new TestsScope();

    private TestsScope() {
        super(NAME, IconManager.getInstance().createOffsetIcon(AllIcons.Scope.Tests), new FilteredPackageSet(NAME){

            @Override
            public boolean contains(@NotNull VirtualFile file, @NotNull Project project) {
                return TestSourcesFilter.isTestSources(file, project);
            }
        });
    }

    @Override
    public String getDefaultColorName() {
        return "Green";
    }
}

