/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.ProjectFilesScope;
import com.intellij.psi.search.scope.packageSet.FilteredPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.ui.IconManager;
import org.jetbrains.annotations.NotNull;

public final class ProjectProductionScope
extends NamedScope {
    public static final ProjectProductionScope INSTANCE = new ProjectProductionScope();

    private ProjectProductionScope() {
        super(ProjectProductionScope.getNameText(), IconManager.getInstance().createOffsetIcon(AllIcons.Scope.Production), new FilteredPackageSet(ProjectProductionScope.getNameText()){

            @Override
            public boolean contains(@NotNull VirtualFile file, @NotNull Project project) {
                ProjectFileIndex index = ProjectFilesScope.getFileIndex(project);
                return index != null && index.isInSource(file) && !index.isInLibrary(file) && !TestSourcesFilter.isTestSources(file, project);
            }
        });
    }

    public static String getNameText() {
        return AnalysisBundle.message("predefined.scope.production.name", new Object[0]);
    }
}

