/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public interface PsiReferenceProcessor {
    public boolean execute(PsiReference var1);

    public static class CollectElements
    implements PsiReferenceProcessor {
        private final Collection<PsiReference> myCollection;

        public CollectElements(Collection<PsiReference> collection) {
            this.myCollection = Collections.synchronizedCollection(collection);
        }

        public CollectElements() {
            this(new ArrayList<PsiReference>());
        }

        public PsiReference @NotNull [] toArray() {
            return this.myCollection.toArray(PsiReference.EMPTY_ARRAY);
        }

        public PsiReference @NotNull [] toArray(PsiReference[] array) {
            return this.myCollection.toArray(array);
        }

        @Override
        public boolean execute(PsiReference element) {
            this.myCollection.add(element);
            return true;
        }
    }
}

