/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class GlobalSearchScopeUtil {
    @NotNull
    public static GlobalSearchScope toGlobalSearchScope(@NotNull SearchScope scope, @NotNull Project project) {
        if (scope instanceof GlobalSearchScope) {
            return (GlobalSearchScope)scope;
        }
        return (GlobalSearchScope)ReadAction.compute(() -> GlobalSearchScope.filesScope(project, GlobalSearchScopeUtil.getLocalScopeFiles((LocalSearchScope)scope)));
    }

    @NotNull
    public static Set<VirtualFile> getLocalScopeFiles(@NotNull LocalSearchScope scope) {
        return (Set)ReadAction.compute(() -> {
            LinkedHashSet files = new LinkedHashSet();
            for (PsiElement element : scope.getScope()) {
                PsiFile file = element.getContainingFile();
                if (file == null) continue;
                ContainerUtil.addIfNotNull(files, (Object)file.getVirtualFile());
                ContainerUtil.addIfNotNull(files, (Object)file.getNavigationElement().getContainingFile().getVirtualFile());
            }
            return files;
        });
    }
}

