/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileTypeIndex {
    @ApiStatus.Internal
    public static final ID<FileType, Void> NAME = ID.create("filetypes");

    @Nullable
    public static FileType getIndexedFileType(@NotNull VirtualFile file, @NotNull Project project) {
        Map<FileType, Void> data = FileBasedIndex.getInstance().getFileData(NAME, file, project);
        return (FileType)ContainerUtil.getFirstItem(data.keySet());
    }

    @NotNull
    public static Collection<VirtualFile> getFiles(@NotNull FileType fileType, @NotNull GlobalSearchScope scope) {
        return FileBasedIndex.getInstance().getContainingFiles(NAME, fileType, scope);
    }

    public static boolean containsFileOfType(@NotNull FileType type, @NotNull GlobalSearchScope scope) {
        return !FileTypeIndex.processFiles(type, (Processor<? super VirtualFile>)CommonProcessors.alwaysFalse(), scope);
    }

    public static boolean processFiles(@NotNull FileType fileType, @NotNull Processor<? super VirtualFile> processor, @NotNull GlobalSearchScope scope) {
        return FileBasedIndex.getInstance().processValues(NAME, fileType, null, (file, value) -> processor.process((Object)file), scope);
    }
}

