/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.model.ModelBranch;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtilRt;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DelegatingGlobalSearchScope
extends GlobalSearchScope {
    protected final GlobalSearchScope myBaseScope;
    private final Object myEquality;

    public DelegatingGlobalSearchScope(@NotNull GlobalSearchScope baseScope) {
        this(baseScope, ArrayUtilRt.EMPTY_OBJECT_ARRAY);
    }

    public DelegatingGlobalSearchScope(@NotNull GlobalSearchScope baseScope, Object ... equality) {
        super(baseScope.getProject());
        this.myBaseScope = baseScope;
        this.myEquality = Arrays.asList(equality);
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        return this.myBaseScope.contains(file);
    }

    @Override
    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        return this.myBaseScope.compare(file1, file2);
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        return this.myBaseScope.isSearchInModuleContent(aModule);
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
        return this.myBaseScope.isSearchInModuleContent(aModule, testSources);
    }

    @Override
    public boolean isSearchInLibraries() {
        return this.myBaseScope.isSearchInLibraries();
    }

    @Override
    @NotNull
    public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
        return this.myBaseScope.getUnloadedModulesBelongingToScope();
    }

    @Override
    @NotNull
    public Collection<ModelBranch> getModelBranchesAffectingScope() {
        return this.myBaseScope.getModelBranchesAffectingScope();
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return this.myBaseScope.getDisplayName();
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return this.myBaseScope.getIcon();
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.myBaseScope + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DelegatingGlobalSearchScope that = (DelegatingGlobalSearchScope)o;
        if (!this.myBaseScope.equals(that.myBaseScope)) {
            return false;
        }
        return this.myEquality.equals(that.myEquality);
    }

    @Override
    public int calcHashCode() {
        int result = this.myBaseScope.calcHashCode();
        result = 31 * result + this.myEquality.hashCode();
        return result;
    }
}

