/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.extractor.values;

import com.intellij.psi.codeStyle.extractor.values.ClassSerializer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Value {
    @NotNull
    public final String name;
    @NotNull
    public Object value;
    @NotNull
    public STATE state;
    @NotNull
    public ClassSerializer serializer;
    @NotNull
    public final VAR_KIND kind;

    public Object[] getPossibleValues() {
        return this.kind.getPossibleValues();
    }

    public int getMutagenFactor() {
        return this.kind.getMutagenFactor();
    }

    public Value(@NotNull String name, @NotNull Object value, @NotNull ClassSerializer serializer, @NotNull VAR_KIND kind) {
        this.kind = kind;
        this.name = name;
        this.value = value instanceof Integer && (Integer)value == 0 && kind == VAR_KIND.BRACE_STYLE ? Integer.valueOf(1) : value;
        this.state = STATE.INIT;
        this.serializer = serializer;
    }

    public Value(@NotNull Value valueZ) {
        this.name = valueZ.name;
        this.value = valueZ.value;
        this.state = valueZ.state;
        this.serializer = valueZ.serializer;
        this.kind = valueZ.kind;
    }

    @Nullable
    @Contract(value="false -> null")
    public Value write(boolean retPrevValue) {
        Object orig = this.serializer.write(this.name, this.value, retPrevValue);
        return orig == null ? null : new Value(this.name, orig, this.serializer, this.kind);
    }

    public String toString() {
        return this.name + "=" + this.value + ";";
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Value) {
            Value other = (Value)o;
            return other.name.equals(this.name) && other.serializer.equals(this.serializer);
        }
        return false;
    }

    public static abstract class CLASS_BASED_VAR_KIND
    extends VAR_KIND {
        private final Class<?> myVarClass;

        public CLASS_BASED_VAR_KIND(Object @NotNull [] possibleValues, @NotNull Class<?> varClass) {
            super(possibleValues);
            this.myVarClass = varClass;
        }

        @Override
        public boolean accepts(@NotNull String name, @NotNull Object value) {
            return value.getClass().equals(this.myVarClass) && this.acceptsName(name);
        }

        public abstract boolean acceptsName(@NotNull String var1);
    }

    public static abstract class VAR_KIND {
        private final Object @NotNull [] myPossibleValues;
        public static final VAR_KIND RIGHT_MARGIN = new CLASS_BASED_VAR_KIND(VAR_KIND.getRMValues(), (Class)Integer.class){

            @Override
            public boolean acceptsName(@NotNull String name) {
                return name.equals("RIGHT_MARGIN");
            }

            @Override
            public int getMutagenFactor() {
                return 0;
            }
        };
        public static final VAR_KIND BLANK = new CLASS_BASED_VAR_KIND(new Object[]{0, 1, 2}, (Class)Integer.class){

            @Override
            public boolean acceptsName(@NotNull String name) {
                return name.contains("BLANK");
            }

            @Override
            public int getMutagenFactor() {
                return 2;
            }
        };
        public static final VAR_KIND INDENT = new CLASS_BASED_VAR_KIND(new Object[]{0, 1, 2, 3, 4, 5, 6, 7, 8}, (Class)Integer.class){

            @Override
            public boolean acceptsName(@NotNull String name) {
                return name.contains("INDENT");
            }

            @Override
            public int getMutagenFactor() {
                return 7;
            }
        };
        public static final VAR_KIND DEFAULT = new CLASS_BASED_VAR_KIND(new Object[]{0, 1, 2, 3, 4, 5, 6, 7, 8}, (Class)Integer.class){

            @Override
            public boolean acceptsName(@NotNull String name) {
                return true;
            }
        };
        public static final VAR_KIND TAB_SIZE = new CLASS_BASED_VAR_KIND(new Object[]{2, 4, 8}, (Class)Integer.class){

            @Override
            public boolean acceptsName(@NotNull String name) {
                return name.contains("TAB_SIZE");
            }

            @Override
            public int getMutagenFactor() {
                return 2;
            }
        };
        public static final VAR_KIND WRAP = new CLASS_BASED_VAR_KIND(new Object[]{0, 1, 2, 5}, (Class)Integer.class){

            @Override
            public boolean acceptsName(@NotNull String name) {
                return name.endsWith("_WRAP");
            }
        };
        public static final VAR_KIND BRACE_STYLE = new CLASS_BASED_VAR_KIND(new Object[]{1, 2, 3, 4, 5}, (Class)Integer.class){

            @Override
            public boolean acceptsName(@NotNull String name) {
                return name.endsWith("BRACE_STYLE") || name.endsWith("BRACE_PLACEMENT");
            }

            @Override
            public int getMutagenFactor() {
                return 7;
            }
        };
        public static final VAR_KIND KEEP = new CLASS_BASED_VAR_KIND(new Object[]{true, false}, (Class)Boolean.class){

            @Override
            public boolean acceptsName(@NotNull String name) {
                return name.contains("KEEP");
            }

            @Override
            public int getMutagenFactor() {
                return 3;
            }
        };
        public static final VAR_KIND BOOL = new CLASS_BASED_VAR_KIND(new Object[]{true, false}, (Class)Boolean.class){

            @Override
            public boolean acceptsName(@NotNull String name) {
                return true;
            }
        };
        public static final VAR_KIND NOTHING = new VAR_KIND(new Object[0]){

            @Override
            public boolean accepts(@NotNull String name, @NotNull Object value) {
                return true;
            }
        };
        public static final VAR_KIND[] defaultKinds = new VAR_KIND[]{RIGHT_MARGIN, WRAP, BRACE_STYLE, TAB_SIZE, INDENT, BLANK, DEFAULT, KEEP, BOOL, NOTHING};

        public int getMutagenFactor() {
            return 1;
        }

        VAR_KIND(Object @NotNull [] possibleValues) {
            this.myPossibleValues = possibleValues;
        }

        public Object @NotNull [] getPossibleValues() {
            return this.myPossibleValues;
        }

        public abstract boolean accepts(@NotNull String var1, @NotNull Object var2);

        private static Object @NotNull [] getRMValues() {
            int from = 10;
            int to = 120;
            Object[] ret = new Object[to - from + 1];
            ret[0] = -1;
            for (int i = to; i > from; --i) {
                ret[i - from] = i;
            }
            return ret;
        }
    }

    public static enum STATE {
        INIT,
        SELECTED,
        ANY;

    }
}

