/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.std;

import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokenUiRole;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CompositeArrangementSettingsToken {
    private static final Function<ArrangementSettingsToken, CompositeArrangementSettingsToken> WRAPPER = token -> new CompositeArrangementSettingsToken((ArrangementSettingsToken)token, CompositeArrangementSettingsToken.deduceRole(token), Collections.emptyList());
    @NotNull
    private final List<CompositeArrangementSettingsToken> myChildren = new ArrayList<CompositeArrangementSettingsToken>();
    @NotNull
    private final ArrangementSettingsToken myToken;
    @NotNull
    private final StdArrangementTokenUiRole myRole;

    public CompositeArrangementSettingsToken(@NotNull ArrangementSettingsToken token) {
        this(token, CompositeArrangementSettingsToken.deduceRole(token), Collections.emptyList());
    }

    public CompositeArrangementSettingsToken(@NotNull ArrangementSettingsToken token, ArrangementSettingsToken ... children) {
        this(token, CompositeArrangementSettingsToken.deduceRole(token), ContainerUtil.map2List(Arrays.asList(children), WRAPPER));
    }

    public CompositeArrangementSettingsToken(@NotNull ArrangementSettingsToken token, @NotNull Collection<? extends ArrangementSettingsToken> children) {
        this(token, CompositeArrangementSettingsToken.deduceRole(token), ContainerUtil.map2List(children, WRAPPER));
    }

    public CompositeArrangementSettingsToken(@NotNull ArrangementSettingsToken token, @NotNull StdArrangementTokenUiRole role, @NotNull List<? extends CompositeArrangementSettingsToken> children) {
        this.myToken = token;
        this.myRole = role;
        this.myChildren.addAll(children);
    }

    @NotNull
    private static StdArrangementTokenUiRole deduceRole(@NotNull ArrangementSettingsToken token) {
        StdArrangementTokenUiRole role;
        StdArrangementTokenUiRole stdArrangementTokenUiRole = role = token instanceof StdArrangementSettingsToken ? ((StdArrangementSettingsToken)token).getTokenType().getUiRole() : null;
        if (role == null) {
            throw new IllegalArgumentException("Can't deduce UI role for token " + token);
        }
        return role;
    }

    @NotNull
    public List<CompositeArrangementSettingsToken> getChildren() {
        return this.myChildren;
    }

    @NotNull
    public ArrangementSettingsToken getToken() {
        return this.myToken;
    }

    @NotNull
    public StdArrangementTokenUiRole getRole() {
        return this.myRole;
    }

    public String toString() {
        return this.myToken.toString() + "-" + (Object)((Object)this.myRole);
    }
}

