/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.std;

import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSectionRuleAwareSettings;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsAware;
import com.intellij.psi.codeStyle.arrangement.std.CompositeArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.InvertibleArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementRuleAliasToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementStandardSettingsManager {
    @NotNull
    private final TObjectIntHashMap<ArrangementSettingsToken> myWidths = new TObjectIntHashMap();
    @NotNull
    private final TObjectIntHashMap<ArrangementSettingsToken> myWeights = new TObjectIntHashMap();
    @NotNull
    private final Comparator<ArrangementSettingsToken> myComparator = (t1, t2) -> {
        if (this.myWeights.containsKey(t1)) {
            if (this.myWeights.containsKey(t2)) {
                return this.myWeights.get(t1) - this.myWeights.get(t2);
            }
            return -1;
        }
        if (this.myWeights.containsKey(t2)) {
            return 1;
        }
        return t1.compareTo((ArrangementSettingsToken)t2);
    };
    @NotNull
    private final ArrangementStandardSettingsAware myDelegate;
    @NotNull
    private final ArrangementColorsProvider myColorsProvider;
    @NotNull
    private final Collection<Set<ArrangementSettingsToken>> myMutexes;
    @Nullable
    private final StdArrangementSettings myDefaultSettings;
    @Nullable
    private final List<CompositeArrangementSettingsToken> myGroupingTokens;
    @Nullable
    private final List<CompositeArrangementSettingsToken> myMatchingTokens;
    @NotNull
    private final Collection<StdArrangementRuleAliasToken> myRuleAliases;
    @NotNull
    private final Set<ArrangementSettingsToken> myRuleAliasMutex;
    @Nullable
    private CompositeArrangementSettingsToken myRuleAliasToken;

    public ArrangementStandardSettingsManager(@NotNull ArrangementStandardSettingsAware delegate, @NotNull ArrangementColorsProvider colorsProvider) {
        this(delegate, colorsProvider, ContainerUtil.emptyList());
    }

    public ArrangementStandardSettingsManager(@NotNull ArrangementStandardSettingsAware delegate, @NotNull ArrangementColorsProvider colorsProvider, @NotNull Collection<StdArrangementRuleAliasToken> aliases) {
        this.myDelegate = delegate;
        this.myColorsProvider = colorsProvider;
        this.myMutexes = delegate.getMutexes();
        this.myDefaultSettings = delegate.getDefaultSettings();
        SimpleColoredComponent renderer = new SimpleColoredComponent();
        this.myGroupingTokens = delegate.getSupportedGroupingTokens();
        if (this.myGroupingTokens != null) {
            this.parseWidths(this.myGroupingTokens, renderer);
            this.buildWeights(this.myGroupingTokens);
        }
        this.myMatchingTokens = delegate.getSupportedMatchingTokens();
        if (this.myMatchingTokens != null) {
            this.parseWidths(this.myMatchingTokens, renderer);
            this.buildWeights(this.myMatchingTokens);
        }
        HashSet<ArrangementSettingsToken> aliasTokens = new HashSet<ArrangementSettingsToken>();
        aliasTokens.addAll(aliases);
        this.myRuleAliases = aliases;
        this.myRuleAliasMutex = aliasTokens;
        if (!this.myRuleAliases.isEmpty()) {
            this.myRuleAliasToken = new CompositeArrangementSettingsToken(StdArrangementTokens.General.ALIAS, aliasTokens);
        }
    }

    @NotNull
    public Collection<StdArrangementRuleAliasToken> getRuleAliases() {
        return this.myRuleAliases;
    }

    @NotNull
    public ArrangementStandardSettingsAware getDelegate() {
        return this.myDelegate;
    }

    private void parseWidths(@NotNull Collection<? extends CompositeArrangementSettingsToken> compositeTokens, @NotNull SimpleColoredComponent renderer) {
        int width = 0;
        for (CompositeArrangementSettingsToken compositeArrangementSettingsToken : compositeTokens) {
            width = Math.max(width, this.parseWidth(compositeArrangementSettingsToken.getToken(), renderer));
        }
        for (CompositeArrangementSettingsToken compositeArrangementSettingsToken : compositeTokens) {
            this.myWidths.put((Object)compositeArrangementSettingsToken.getToken(), width);
            this.parseWidths(compositeArrangementSettingsToken.getChildren(), renderer);
        }
    }

    private void buildWeights(@NotNull Collection<? extends CompositeArrangementSettingsToken> compositeTokens) {
        for (CompositeArrangementSettingsToken compositeArrangementSettingsToken : compositeTokens) {
            this.myWeights.put((Object)compositeArrangementSettingsToken.getToken(), this.myWeights.size());
            this.buildWeights(compositeArrangementSettingsToken.getChildren());
        }
    }

    @Nullable
    public StdArrangementSettings getDefaultSettings() {
        return this.myDefaultSettings;
    }

    public boolean isSectionRulesSupported() {
        return this.myDelegate instanceof ArrangementSectionRuleAwareSettings;
    }

    @Nullable
    public List<CompositeArrangementSettingsToken> getSupportedGroupingTokens() {
        return this.myGroupingTokens;
    }

    @Nullable
    public List<CompositeArrangementSettingsToken> getSupportedMatchingTokens() {
        if (this.myMatchingTokens == null || this.myRuleAliasToken == null) {
            return this.myMatchingTokens;
        }
        ArrayList<CompositeArrangementSettingsToken> allTokens = new ArrayList<CompositeArrangementSettingsToken>(this.myMatchingTokens);
        allTokens.add(this.myRuleAliasToken);
        return allTokens;
    }

    public boolean isEnabled(@NotNull ArrangementSettingsToken token, @Nullable ArrangementMatchCondition current) {
        if (this.myRuleAliasMutex.contains(token)) {
            return true;
        }
        return this.myDelegate.isEnabled(token, current);
    }

    @NotNull
    public ArrangementEntryMatcher buildMatcher(@NotNull ArrangementMatchCondition condition) throws IllegalArgumentException {
        ArrangementEntryMatcher matcher = ArrangementUtil.buildMatcher(condition);
        if (matcher == null) {
            matcher = this.myDelegate.buildMatcher(condition);
        }
        return matcher;
    }

    @NotNull
    public Collection<Set<ArrangementSettingsToken>> getMutexes() {
        if (this.myRuleAliasMutex.isEmpty()) {
            return this.myMutexes;
        }
        ArrayList<Set<ArrangementSettingsToken>> allMutexes = new ArrayList<Set<ArrangementSettingsToken>>(this.myMutexes);
        allMutexes.add(this.myRuleAliasMutex);
        return allMutexes;
    }

    public int getWidth(@NotNull ArrangementSettingsToken token) {
        if (this.myWidths.containsKey((Object)token)) {
            return this.myWidths.get((Object)token);
        }
        return this.parseWidth(token, new SimpleColoredComponent());
    }

    private int parseWidth(@NotNull ArrangementSettingsToken token, @NotNull SimpleColoredComponent renderer) {
        renderer.clear();
        String value = ArrangementStandardSettingsManager.getPresentationValue(token);
        renderer.append(value, SimpleTextAttributes.fromTextAttributes((TextAttributes)this.myColorsProvider.getTextAttributes(token, true)));
        int result = renderer.getPreferredSize().width;
        renderer.clear();
        renderer.append(value, SimpleTextAttributes.fromTextAttributes((TextAttributes)this.myColorsProvider.getTextAttributes(token, false)));
        return Math.max(result, renderer.getPreferredSize().width);
    }

    @NotNull
    private static String getPresentationValue(@NotNull ArrangementSettingsToken token) {
        if (token instanceof InvertibleArrangementSettingsToken) {
            return ((InvertibleArrangementSettingsToken)((Object)token)).getInvertedRepresentationValue();
        }
        return token.getRepresentationValue();
    }

    public List<ArrangementSettingsToken> sort(@NotNull Collection<? extends ArrangementSettingsToken> tokens) {
        ArrayList<ArrangementSettingsToken> result = new ArrayList<ArrangementSettingsToken>(tokens);
        result.sort(this.myComparator);
        return result;
    }
}

