/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.util.xmlb.XmlSerializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SoftMargins
implements Cloneable {
    private List<Integer> myValues;

    SoftMargins() {
    }

    @Nullable
    public String getSOFT_MARGINS() {
        return this.myValues != null ? this.toString() : null;
    }

    public void setSOFT_MARGINS(@Nullable String valueList) {
        if (valueList != null) {
            String[] values = valueList.split(",\\s*");
            this.myValues = new ArrayList<Integer>(values.length);
            for (String value : values) {
                try {
                    this.myValues.add(Integer.parseInt(value));
                }
                catch (NumberFormatException nfe) {
                    this.myValues = null;
                    return;
                }
            }
            Collections.sort(this.myValues);
        }
    }

    @NotNull
    List<Integer> getValues() {
        return this.myValues != null ? this.myValues : Collections.emptyList();
    }

    void setValues(List<Integer> values) {
        if (values != null) {
            this.myValues = new ArrayList<Integer>(values);
            Collections.sort(this.myValues);
        } else {
            this.myValues = null;
        }
    }

    public Object clone() {
        SoftMargins copy = new SoftMargins();
        copy.setValues(this.myValues);
        return copy;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SoftMargins) {
            List<Integer> otherMargins = ((SoftMargins)obj).getValues();
            return otherMargins.equals(this.getValues());
        }
        return false;
    }

    public String toString() {
        if (this.myValues == null) {
            return "";
        }
        return this.myValues.stream().map(String::valueOf).collect(Collectors.joining(","));
    }

    public void serializeInto(@NotNull Element element) {
        if (this.myValues != null && this.myValues.size() > 0) {
            XmlSerializer.serializeInto((Object)this, (Element)element);
        }
    }

    public void deserializeFrom(@NotNull Element element) {
        XmlSerializer.deserializeInto((Object)this, (Element)element);
    }
}

