/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.modifier.CodeStyleStatusBarUIContributor;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IndentStatusBarUIContributor
implements CodeStyleStatusBarUIContributor {
    private final CommonCodeStyleSettings.IndentOptions myIndentOptions;

    public IndentStatusBarUIContributor(CommonCodeStyleSettings.IndentOptions options) {
        this.myIndentOptions = options;
    }

    public CommonCodeStyleSettings.IndentOptions getIndentOptions() {
        return this.myIndentOptions;
    }

    @Nullable
    public abstract String getHint();

    @Override
    @Nullable
    public String getTooltip() {
        return IndentStatusBarUIContributor.createTooltip(IndentStatusBarUIContributor.getIndentInfo(this.myIndentOptions), this.getHint());
    }

    @Nls
    @NotNull
    public static String getIndentInfo(@NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        return indentOptions.USE_TAB_CHARACTER ? CodeInsightBundle.message("indent.status.bar.tab", new Object[0]) : CodeInsightBundle.message("indent.status.bar.spaces", indentOptions.INDENT_SIZE);
    }

    public boolean isShowFileIndentOptionsEnabled() {
        return true;
    }

    @NotNull
    public static String createTooltip(String indentInfo, String hint) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>").append(CodeInsightBundle.message("indent.status.bar.indent.tooltip", new Object[0])).append(indentInfo);
        if (hint != null) {
            sb.append("&nbsp;&nbsp;").append("<span style=\"color:#").append(ColorUtil.toHex((Color)JBColor.GRAY)).append("\">");
            sb.append(StringUtil.capitalize((String)hint));
            sb.append("</span>");
        }
        return sb.append("</html>").toString();
    }

    @Override
    @NotNull
    public String getStatusText(@NotNull PsiFile psiFile) {
        String indentInfo = IndentStatusBarUIContributor.getIndentInfo(this.myIndentOptions);
        StringBuilder widgetText = new StringBuilder();
        widgetText.append(indentInfo);
        CommonCodeStyleSettings.IndentOptions projectIndentOptions = CodeStyle.getSettings(psiFile.getProject()).getLanguageIndentOptions(psiFile.getLanguage());
        if (!projectIndentOptions.equals(this.myIndentOptions)) {
            widgetText.append("*");
        }
        return widgetText.toString();
    }
}

