/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.lang.IdeLanguageCustomization;
import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleGroup;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.DisplayPriority;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CodeStyleSettingsProvider {
    public static final ExtensionPointName<CodeStyleSettingsProvider> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"com.intellij.codeStyleSettingsProvider");

    @Nullable
    public CustomCodeStyleSettings createCustomSettings(CodeStyleSettings settings) {
        return null;
    }

    @Deprecated
    @NotNull
    public Configurable createSettingsPage(CodeStyleSettings settings, CodeStyleSettings modelSettings) {
        return null;
    }

    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings settings, @NotNull CodeStyleSettings modelSettings) {
        Configurable configurable = this.createSettingsPage(settings, modelSettings);
        if (configurable instanceof CodeStyleConfigurable) {
            return (CodeStyleConfigurable)configurable;
        }
        return new LegacyConfigurableWrapper(configurable);
    }

    @Nullable
    public String getConfigurableDisplayName() {
        Language lang = this.getLanguage();
        return lang == null ? null : lang.getDisplayName();
    }

    public boolean hasSettingsPage() {
        return true;
    }

    public DisplayPriority getPriority() {
        List<Language> primaryIdeLanguages = IdeLanguageCustomization.getInstance().getPrimaryIdeLanguages();
        return primaryIdeLanguages.contains((Object)this.getLanguage()) ? DisplayPriority.KEY_LANGUAGE_SETTINGS : DisplayPriority.LANGUAGE_SETTINGS;
    }

    @Nullable
    public Language getLanguage() {
        return null;
    }

    @Nullable
    public CodeStyleGroup getGroup() {
        return null;
    }

    private static class LegacyConfigurableWrapper
    implements CodeStyleConfigurable {
        private final Configurable myConfigurable;

        private LegacyConfigurableWrapper(Configurable configurable) {
            this.myConfigurable = configurable;
        }

        @Override
        public void reset(@NotNull CodeStyleSettings settings) {
            this.myConfigurable.reset();
        }

        @Override
        public void apply(@NotNull CodeStyleSettings settings) throws ConfigurationException {
            this.myConfigurable.apply();
        }

        @Override
        @Nls(capitalization=Nls.Capitalization.Title)
        public String getDisplayName() {
            return this.myConfigurable.getDisplayName();
        }

        @Override
        @Nullable
        public JComponent createComponent() {
            return this.myConfigurable.createComponent();
        }

        @Override
        public boolean isModified() {
            return this.myConfigurable.isModified();
        }

        @Override
        public void apply() throws ConfigurationException {
            this.myConfigurable.apply();
        }
    }
}

