/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.DifferenceFilter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.AppCodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsChangeEvent;
import com.intellij.psi.codeStyle.CodeStyleSettingsListener;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.psi.codeStyle.FileTypeIndentOptionsProvider;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.ProjectCodeStyleSettingsManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSettingsManager
implements PersistentStateComponentWithModificationTracker<Element> {
    private static final Logger LOG = Logger.getInstance(CodeStyleSettingsManager.class);
    @Deprecated
    @Nullable
    public volatile CodeStyleSettings PER_PROJECT_SETTINGS;
    public volatile boolean USE_PER_PROJECT_SETTINGS;
    public volatile String PREFERRED_PROJECT_CODE_STYLE;
    private volatile CodeStyleSettings myTemporarySettings;
    private final List<CodeStyleSettingsListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private static final WeakList<CodeStyleSettings> ourReferencedSettings = new WeakList();

    public CodeStyleSettings createSettings() {
        CodeStyleSettings newSettings = new CodeStyleSettings(true, false);
        CodeStyleSettingsManager.registerSettings(newSettings);
        return newSettings;
    }

    static void registerSettings(CodeStyleSettings newSettings) {
        ourReferencedSettings.add((Object)newSettings);
    }

    public final CodeStyleSettings createTemporarySettings() {
        this.myTemporarySettings = new CodeStyleSettings(true, false);
        return this.myTemporarySettings;
    }

    public final CodeStyleSettings cloneSettings(@NotNull CodeStyleSettings settings) {
        CodeStyleSettings clonedSettings = new CodeStyleSettings(true, false);
        clonedSettings.copyFrom(settings);
        CodeStyleSettingsManager.registerSettings(clonedSettings);
        return clonedSettings;
    }

    public static CodeStyleSettings createTestSettings(@Nullable CodeStyleSettings baseSettings) {
        CodeStyleSettings testSettings = new CodeStyleSettings(true, false);
        if (baseSettings != null) {
            testSettings.copyFrom(baseSettings);
        }
        return testSettings;
    }

    private Collection<CodeStyleSettings> getAllSettings() {
        ArrayList<CodeStyleSettings> allSettings = new ArrayList<CodeStyleSettings>(this.enumSettings());
        allSettings.addAll(ourReferencedSettings.toStrongList());
        return allSettings;
    }

    @Override
    public long getStateModificationCount() {
        return this.enumSettings().stream().mapToLong(settings -> settings.getModificationTracker().getModificationCount()).sum();
    }

    public static CodeStyleSettingsManager getInstance(@Nullable Project project) {
        if (project == null || project.isDefault()) {
            return CodeStyleSettingsManager.getInstance();
        }
        return (CodeStyleSettingsManager)project.getService(ProjectCodeStyleSettingsManager.class);
    }

    public static CodeStyleSettingsManager getInstance() {
        return (CodeStyleSettingsManager)ApplicationManager.getApplication().getService(AppCodeStyleSettingsManager.class);
    }

    protected void registerExtensionPointListeners(@NotNull Disposable disposable) {
        FileIndentOptionsProvider.EP_NAME.addChangeListener(this::notifyCodeStyleSettingsChanged, disposable);
        FileTypeIndentOptionsProvider.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<FileTypeIndentOptionsProvider>(){

            public void extensionAdded(@NotNull FileTypeIndentOptionsProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                CodeStyleSettingsManager.this.registerFileTypeIndentOptions(CodeStyleSettingsManager.this.getAllSettings(), extension.getFileType(), extension.createIndentOptions());
            }

            public void extensionRemoved(@NotNull FileTypeIndentOptionsProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                CodeStyleSettingsManager.this.unregisterFileTypeIndentOptions(CodeStyleSettingsManager.this.getAllSettings(), extension.getFileType());
            }
        }, disposable);
        LanguageCodeStyleSettingsProvider.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<LanguageCodeStyleSettingsProvider>(){

            public void extensionAdded(@NotNull LanguageCodeStyleSettingsProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                LanguageCodeStyleSettingsProvider.registerSettingsPageProvider(extension);
                CodeStyleSettingsManager.this.registerLanguageSettings(CodeStyleSettingsManager.this.getAllSettings(), extension);
                CodeStyleSettingsManager.this.registerCustomSettings(CodeStyleSettingsManager.this.getAllSettings(), extension);
            }

            public void extensionRemoved(@NotNull LanguageCodeStyleSettingsProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                LanguageCodeStyleSettingsProvider.unregisterSettingsPageProvider(extension);
                CodeStyleSettingsManager.this.unregisterLanguageSettings(CodeStyleSettingsManager.this.getAllSettings(), extension);
                CodeStyleSettingsManager.this.unregisterCustomSettings(CodeStyleSettingsManager.this.getAllSettings(), extension);
            }
        }, disposable);
        CodeStyleSettingsProvider.EXTENSION_POINT_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<CodeStyleSettingsProvider>(){

            public void extensionAdded(@NotNull CodeStyleSettingsProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                CodeStyleSettingsManager.this.registerCustomSettings(CodeStyleSettingsManager.this.getAllSettings(), extension);
            }

            public void extensionRemoved(@NotNull CodeStyleSettingsProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                CodeStyleSettingsManager.this.unregisterCustomSettings(CodeStyleSettingsManager.this.getAllSettings(), extension);
            }
        }, disposable);
    }

    protected Collection<CodeStyleSettings> enumSettings() {
        return Collections.emptyList();
    }

    @ApiStatus.Internal
    public final void registerFileTypeIndentOptions(@NotNull Collection<CodeStyleSettings> allSettings, @NotNull FileType fileType, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        allSettings.forEach(settings -> settings.registerAdditionalIndentOptions(fileType, indentOptions));
        this.notifyCodeStyleSettingsChanged();
    }

    @ApiStatus.Internal
    public final void unregisterFileTypeIndentOptions(@NotNull Collection<CodeStyleSettings> allSettings, @NotNull FileType fileType) {
        allSettings.forEach(settings -> settings.unregisterAdditionalIndentOptions(fileType));
        this.notifyCodeStyleSettingsChanged();
    }

    @ApiStatus.Internal
    public final void registerLanguageSettings(@NotNull Collection<CodeStyleSettings> allSettings, @NotNull LanguageCodeStyleSettingsProvider provider) {
        allSettings.forEach(settings -> settings.registerSettings(provider));
        this.notifyCodeStyleSettingsChanged();
    }

    @ApiStatus.Internal
    public final void unregisterLanguageSettings(@NotNull Collection<CodeStyleSettings> allSettings, @NotNull LanguageCodeStyleSettingsProvider provider) {
        allSettings.forEach(settings -> settings.removeSettings(provider));
        this.notifyCodeStyleSettingsChanged();
    }

    @ApiStatus.Internal
    public final void registerCustomSettings(@NotNull Collection<CodeStyleSettings> allSettings, @NotNull CodeStyleSettingsProvider provider) {
        allSettings.forEach(settings -> settings.registerSettings(provider));
        this.notifyCodeStyleSettingsChanged();
    }

    @ApiStatus.Internal
    public final void unregisterCustomSettings(@NotNull Collection<CodeStyleSettings> allSettings, @NotNull CodeStyleSettingsProvider provider) {
        allSettings.forEach(settings -> settings.removeSettings(provider));
        this.notifyCodeStyleSettingsChanged();
    }

    @Deprecated
    @NotNull
    public static CodeStyleSettings getSettings(@Nullable Project project) {
        return CodeStyleSettingsManager.getInstance(project).getCurrentSettings();
    }

    @Deprecated
    @NotNull
    public CodeStyleSettings getCurrentSettings() {
        CodeStyleSettings temporarySettings = this.myTemporarySettings;
        if (temporarySettings != null) {
            return temporarySettings;
        }
        CodeStyleSettings projectSettings = this.getMainProjectCodeStyle();
        if (this.USE_PER_PROJECT_SETTINGS && projectSettings != null) {
            return projectSettings;
        }
        return CodeStyleSchemes.getInstance().findPreferredScheme(this.PREFERRED_PROJECT_CODE_STYLE).getCodeStyleSettings();
    }

    @Override
    public Element getState() {
        Element result = new Element("state");
        try {
            DefaultJDOMExternalizer.writeExternal((Object)this, (Element)result, (DefaultJDOMExternalizer.JDOMFilter)new DifferenceFilter<CodeStyleSettingsManager>(this, new CodeStyleSettingsManager()){

                public boolean isAccept(@NotNull Field field) {
                    return !CodeStyleSettingsManager.this.isIgnoredOnSave(field.getName()) && super.isAccept(field);
                }
            });
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        return result;
    }

    protected boolean isIgnoredOnSave(@NotNull String fieldName) {
        return false;
    }

    @Override
    public void loadState(@NotNull Element state) {
        try {
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)state);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    public void setMainProjectCodeStyle(@Nullable CodeStyleSettings settings) {
        this.PER_PROJECT_SETTINGS = settings;
    }

    @Nullable
    public CodeStyleSettings getMainProjectCodeStyle() {
        return this.PER_PROJECT_SETTINGS;
    }

    @Deprecated
    public boolean isLoaded() {
        return true;
    }

    public void setTemporarySettings(@NotNull CodeStyleSettings settings) {
        this.myTemporarySettings = settings;
    }

    public void dropTemporarySettings() {
        this.myTemporarySettings = null;
    }

    @Nullable
    public CodeStyleSettings getTemporarySettings() {
        return this.myTemporarySettings;
    }

    public void addListener(@NotNull CodeStyleSettingsListener listener2) {
        this.myListeners.add(listener2);
    }

    private void removeListener(@NotNull CodeStyleSettingsListener listener2) {
        this.myListeners.remove(listener2);
    }

    public static void removeListener(@Nullable Project project, @NotNull CodeStyleSettingsListener listener2) {
        CodeStyleSettingsManager projectInstance;
        if (project == null || project.isDefault()) {
            CodeStyleSettingsManager.getInstance().removeListener(listener2);
        } else if (!project.isDisposed() && (projectInstance = (CodeStyleSettingsManager)ServiceManager.getService(project, ProjectCodeStyleSettingsManager.class)) != null) {
            projectInstance.removeListener(listener2);
        }
    }

    public void fireCodeStyleSettingsChanged(@Nullable PsiFile file) {
        for (CodeStyleSettingsListener listener2 : this.myListeners) {
            listener2.codeStyleSettingsChanged(new CodeStyleSettingsChangeEvent(file));
        }
    }

    public final void notifyCodeStyleSettingsChanged() {
        this.updateSettingsTracker();
        this.fireCodeStyleSettingsChanged(null);
    }

    @ApiStatus.Internal
    public void updateSettingsTracker() {
        CodeStyleSettings settings = this.getCurrentSettings();
        settings.getModificationTracker().incModificationCount();
    }
}

