/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.projectImport;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectOpenProcessor {
    public static final ExtensionPointName<ProjectOpenProcessor> EXTENSION_POINT_NAME = new ExtensionPointName("com.intellij.projectOpenProcessor");

    @NotNull
    @Nls
    public abstract String getName();

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @Nullable
    public Icon getIcon(@NotNull VirtualFile file) {
        return this.getIcon();
    }

    public abstract boolean canOpenProject(@NotNull VirtualFile var1);

    public boolean isProjectFile(@NotNull VirtualFile file) {
        return this.canOpenProject(file);
    }

    @Messages.YesNoCancelResult
    public int askConfirmationForOpeningProject(@NotNull VirtualFile file, @Nullable Project project) {
        return Messages.showYesNoCancelDialog(project, IdeBundle.message("message.open.file.is.project", file.getName()), IdeBundle.message("title.open.project", new Object[0]), IdeBundle.message("message.open.file.is.project.open.as.project", new Object[0]), IdeBundle.message("message.open.file.is.project.open.as.file", new Object[0]), IdeBundle.message("button.cancel", new Object[0]), Messages.getQuestionIcon());
    }

    @Nullable
    public abstract Project doOpenProject(@NotNull VirtualFile var1, @Nullable Project var2, boolean var3);

    public boolean lookForProjectsInDirectory() {
        return true;
    }

    public boolean canImportProjectAfterwards() {
        return false;
    }

    public void importProjectAfterwards(@NotNull Project project, @NotNull VirtualFile file) {
    }

    @Nullable
    public static ProjectOpenProcessor getImportProvider(@NotNull VirtualFile file) {
        return ProjectOpenProcessor.getImportProvider(file, false);
    }

    @Nullable
    public static ProjectOpenProcessor getImportProvider(@NotNull VirtualFile file, boolean onlyIfExistingProjectFile) {
        return (ProjectOpenProcessor)EXTENSION_POINT_NAME.findFirstSafe(provider -> provider.canOpenProject(file) && (!onlyIfExistingProjectFile || provider.isProjectFile(file)));
    }

    public boolean isStrongProjectInfoHolder() {
        return false;
    }
}

