/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StringPattern;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class PsiFilePattern<T extends PsiFile, Self extends PsiFilePattern<T, Self>>
extends PsiElementPattern<T, Self> {
    protected PsiFilePattern(@NotNull InitialPatternCondition<T> condition) {
        super(condition);
    }

    protected PsiFilePattern(Class<T> aClass) {
        super(aClass);
    }

    public Self withParentDirectoryName(final StringPattern namePattern) {
        return (Self)((PsiFilePattern)this.with(new PatternCondition<T>("withParentDirectoryName"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                PsiDirectory directory = t.getContainingDirectory();
                return directory != null && namePattern.accepts(directory.getName(), context);
            }
        }));
    }

    public Self withOriginalFile(final ElementPattern<? extends T> filePattern) {
        return (Self)((PsiFilePattern)this.with(new PatternCondition<T>("withOriginalFile"){

            @Override
            public boolean accepts(@NotNull T file, ProcessingContext context) {
                return filePattern.accepts(file.getOriginalFile());
            }
        }));
    }

    public Self withVirtualFile(final ElementPattern<? extends VirtualFile> vFilePattern) {
        return (Self)((PsiFilePattern)this.with(new PatternCondition<T>("withVirtualFile"){

            @Override
            public boolean accepts(@NotNull T file, ProcessingContext context) {
                return vFilePattern.accepts(file.getVirtualFile(), context);
            }
        }));
    }

    public Self withFileType(final ElementPattern<? extends FileType> fileTypePattern) {
        return (Self)((PsiFilePattern)this.with(new PatternCondition<T>("withFileType"){

            @Override
            public boolean accepts(@NotNull T file, ProcessingContext context) {
                return fileTypePattern.accepts(file.getFileType(), context);
            }
        }));
    }

    public static class Capture<T extends PsiFile>
    extends PsiFilePattern<T, Capture<T>> {
        protected Capture(Class<T> aClass) {
            super(aClass);
        }

        public Capture(@NotNull InitialPatternCondition<T> condition) {
            super(condition);
        }
    }
}

