/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.util.containers.WeakList;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WeakFocusStackManager {
    private final WeakList<Component> focusOwners = new WeakList();
    private static final WeakFocusStackManager instance = new WeakFocusStackManager();

    @NotNull
    public static WeakFocusStackManager getInstance() {
        return instance;
    }

    private WeakFocusStackManager() {
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                if (event.getID() == 1004) {
                    WeakFocusStackManager.this.focusOwners.add((Object)((Component)event.getSource()));
                }
            }
        }, 4L);
    }

    @Nullable
    public Component getLastFocusedOutside(Container container) {
        List components = this.focusOwners.toStrongList();
        for (int i = components.size() - 1; i >= 0; --i) {
            if (SwingUtilities.isDescendingFrom((Component)components.get(i), container)) continue;
            return (Component)components.get(i);
        }
        return null;
    }
}

