/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.events;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VFileDeleteEvent
extends VFileEvent {
    @NotNull
    private final VirtualFile myFile;

    public VFileDeleteEvent(@Nullable Object requestor, @NotNull VirtualFile file, boolean isFromRefresh) {
        super(requestor, isFromRefresh);
        this.myFile = file;
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    @NonNls
    public String toString() {
        return "VfsEvent[deleted: " + this.myFile.getUrl() + "]";
    }

    @Override
    @NotNull
    protected String computePath() {
        return this.myFile.getPath();
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        return this.myFile.getFileSystem();
    }

    @Override
    public boolean isValid() {
        return this.myFile.isValid();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFileDeleteEvent event = (VFileDeleteEvent)o;
        return this.myFile.equals(event.myFile);
    }

    @Override
    public int hashCode() {
        return this.myFile.hashCode();
    }
}

