/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.annotations.NotNull;

public class VirtualFileFilteringListener
implements VirtualFileListener {
    private final VirtualFileListener myDelegate;
    @NotNull
    private final VirtualFileSystem myFileSystem;

    public VirtualFileFilteringListener(@NotNull VirtualFileListener delegate, @NotNull VirtualFileSystem fileSystem) {
        this.myDelegate = delegate;
        this.myFileSystem = fileSystem;
    }

    private boolean isFromMySystem(@NotNull VirtualFileEvent event) {
        return event.getFile().getFileSystem() == this.myFileSystem;
    }

    @Override
    public void beforeContentsChange(@NotNull VirtualFileEvent event) {
        if (this.isFromMySystem(event)) {
            this.myDelegate.beforeContentsChange(event);
        }
    }

    @Override
    public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
        if (this.isFromMySystem(event)) {
            this.myDelegate.beforeFileDeletion(event);
        }
    }

    @Override
    public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
        if (this.isFromMySystem(event)) {
            this.myDelegate.beforeFileMovement(event);
        }
    }

    @Override
    public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
        if (this.isFromMySystem(event)) {
            this.myDelegate.beforePropertyChange(event);
        }
    }

    @Override
    public void contentsChanged(@NotNull VirtualFileEvent event) {
        if (this.isFromMySystem(event)) {
            this.myDelegate.contentsChanged(event);
        }
    }

    @Override
    public void fileCopied(@NotNull VirtualFileCopyEvent event) {
        if (this.isFromMySystem(event)) {
            this.myDelegate.fileCopied(event);
        }
    }

    @Override
    public void fileCreated(@NotNull VirtualFileEvent event) {
        if (this.isFromMySystem(event)) {
            this.myDelegate.fileCreated(event);
        }
    }

    @Override
    public void fileDeleted(@NotNull VirtualFileEvent event) {
        if (this.isFromMySystem(event)) {
            this.myDelegate.fileDeleted(event);
        }
    }

    @Override
    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
        if (this.isFromMySystem(event)) {
            this.myDelegate.fileMoved(event);
        }
    }

    @Override
    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        if (this.isFromMySystem(event)) {
            this.myDelegate.propertyChanged(event);
        }
    }
}

