/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.core.CoreBundle;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WritingAccessProvider {
    @Deprecated
    public static final ExtensionPointName<WritingAccessProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.writingAccessProvider");
    public static final ProjectExtensionPointName<WritingAccessProvider> EP = new ProjectExtensionPointName("com.intellij.writingAccessProvider");

    @NotNull
    public Collection<VirtualFile> requestWriting(@NotNull Collection<? extends VirtualFile> files) {
        return this.requestWriting(files.toArray(VirtualFile.EMPTY_ARRAY));
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String getReadOnlyMessage() {
        return CoreBundle.message("editing.read.only.file.hint", new Object[0]);
    }

    @Deprecated
    public Collection<VirtualFile> requestWriting(VirtualFile ... files) {
        throw new AbstractMethodError("requestWriting(List<VirtualFile>) not implemented");
    }

    public boolean isPotentiallyWritable(@NotNull VirtualFile file) {
        return true;
    }

    public static boolean isPotentiallyWritable(@NotNull VirtualFile file, @Nullable Project project) {
        return project == null || project.isDefault() || EP.findFirstSafe((AreaInstance)project, provider -> !provider.isPotentiallyWritable(file)) == null;
    }
}

