/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.Stack;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VirtualFileVisitor<T> {
    public static final Option NO_FOLLOW_SYMLINKS = new Option();
    public static final Option SKIP_ROOT = new Option();
    public static final Option ONE_LEVEL_DEEP = VirtualFileVisitor.limit(1);
    public static final Result CONTINUE = new Result(false, null);
    public static final Result SKIP_CHILDREN = new Result(true, null);
    private boolean myFollowSymLinks = true;
    private boolean mySkipRoot;
    private int myDepthLimit = -1;
    private int myLevel;
    private Stack<T> myValueStack;
    private T myValue;

    @NotNull
    public static Option limit(int maxDepth) {
        return new Option.LimitOption(maxDepth);
    }

    public static Result skipTo(@NotNull VirtualFile parentToSkipTo) {
        return new Result(true, parentToSkipTo);
    }

    protected VirtualFileVisitor(Option ... options) {
        for (Option option : options) {
            if (option == NO_FOLLOW_SYMLINKS) {
                this.myFollowSymLinks = false;
                continue;
            }
            if (option == SKIP_ROOT) {
                this.mySkipRoot = true;
                continue;
            }
            if (!(option instanceof Option.LimitOption)) continue;
            this.myDepthLimit = ((Option.LimitOption)option).limit;
        }
    }

    public boolean visitFile(@NotNull VirtualFile file) {
        return true;
    }

    @NotNull
    public Result visitFileEx(@NotNull VirtualFile file) {
        return this.visitFile(file) ? CONTINUE : SKIP_CHILDREN;
    }

    public void afterChildrenVisited(@NotNull VirtualFile file) {
    }

    @Nullable
    public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file) {
        return null;
    }

    public final void setValueForChildren(@Nullable T value) {
        this.myValue = value;
        if (this.myValueStack == null) {
            this.myValueStack = new Stack();
        }
    }

    public final T getCurrentValue() {
        return this.myValue;
    }

    final boolean allowVisitFile(@NotNull VirtualFile file) {
        return this.myLevel > 0 || !this.mySkipRoot;
    }

    final boolean allowVisitChildren(@NotNull VirtualFile file) {
        if (!file.is(VFileProperty.SYMLINK)) {
            return true;
        }
        if (!this.myFollowSymLinks) {
            return false;
        }
        return !file.isRecursiveOrCircularSymlink();
    }

    final boolean depthLimitReached() {
        return this.myDepthLimit >= 0 && this.myLevel >= this.myDepthLimit;
    }

    final void saveValue() {
        ++this.myLevel;
        if (this.myValueStack != null) {
            this.myValueStack.push(this.myValue);
        }
    }

    final void restoreValue(boolean pushed) {
        if (pushed) {
            --this.myLevel;
            if (this.myValueStack != null && !this.myValueStack.isEmpty()) {
                this.myValueStack.pop();
            }
        }
        if (this.myValueStack != null) {
            this.myValue = this.myValueStack.isEmpty() ? null : this.myValueStack.peek();
        }
    }

    protected static class VisitorException
    extends RuntimeException {
        public VisitorException(@NotNull Throwable cause) {
            super(cause);
        }
    }

    public static class Result {
        public final boolean skipChildren;
        public final VirtualFile skipToParent;

        private Result(boolean skipChildren, @Nullable VirtualFile skipToParent) {
            this.skipChildren = skipChildren;
            this.skipToParent = skipToParent;
        }

        @NonNls
        public String toString() {
            return "(" + (this.skipChildren ? "skip," + this.skipToParent : "continue") + ")";
        }
    }

    public static class Option {
        private Option() {
        }

        private static class LimitOption
        extends Option {
            private final int limit;

            private LimitOption(int limit) {
                this.limit = limit;
            }
        }
    }
}

