/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.history.HistoryCacheBaseKey;
import com.intellij.openapi.vcs.history.HistoryCacheWithRevisionKey;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsCacheableHistorySessionFactory;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.util.Consumer;
import com.intellij.util.containers.SLRUMap;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsHistoryCache {
    private final Object myLock = new Object();
    private final SLRUMap<HistoryCacheBaseKey, CachedHistory> myHistoryCache;
    private final SLRUMap<HistoryCacheWithRevisionKey, Object> myAnnotationCache;

    public VcsHistoryCache() {
        boolean preloadEnabled = Registry.is((String)"vcs.annotations.preload");
        this.myHistoryCache = new SLRUMap(preloadEnabled ? 50 : 10, preloadEnabled ? 50 : 10);
        this.myAnnotationCache = new SLRUMap(preloadEnabled ? 50 : 10, preloadEnabled ? 50 : 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <C extends Serializable, T extends VcsAbstractHistorySession> void put(FilePath filePath2, @Nullable FilePath correctedPath, VcsKey vcsKey, T session, @NotNull VcsCacheableHistorySessionFactory<C, T> factory, boolean isFull) {
        Object object = this.myLock;
        synchronized (object) {
            this.myHistoryCache.put((Object)new HistoryCacheBaseKey(filePath2, vcsKey), (Object)new CachedHistory(correctedPath != null ? correctedPath : filePath2, session.getRevisionList(), session.getCurrentRevisionNumber(), factory.getAdditionallyCachedData(session), isFull));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editCached(FilePath filePath2, VcsKey vcsKey, Consumer<? super List<VcsFileRevision>> consumer) {
        Object object = this.myLock;
        synchronized (object) {
            CachedHistory cachedHistory = (CachedHistory)this.myHistoryCache.get((Object)new HistoryCacheBaseKey(filePath2, vcsKey));
            if (cachedHistory != null) {
                consumer.consume(cachedHistory.getRevisions());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <C extends Serializable, T extends VcsAbstractHistorySession> T getFull(FilePath filePath2, VcsKey vcsKey, @NotNull VcsCacheableHistorySessionFactory<C, T> factory) {
        Object object = this.myLock;
        synchronized (object) {
            CachedHistory cachedHistory = (CachedHistory)this.myHistoryCache.get((Object)new HistoryCacheBaseKey(filePath2, vcsKey));
            if (cachedHistory == null || !cachedHistory.isIsFull()) {
                return null;
            }
            return factory.createFromCachedData((Serializable)cachedHistory.getCustomData(), cachedHistory.getRevisions(), cachedHistory.getPath(), cachedHistory.getCurrentRevision());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <C extends Serializable, T extends VcsAbstractHistorySession> T getMaybePartial(FilePath filePath2, VcsKey vcsKey, @NotNull VcsCacheableHistorySessionFactory<C, T> factory) {
        Object object = this.myLock;
        synchronized (object) {
            CachedHistory cachedHistory = (CachedHistory)this.myHistoryCache.get((Object)new HistoryCacheBaseKey(filePath2, vcsKey));
            if (cachedHistory == null) {
                return null;
            }
            return factory.createFromCachedData((Serializable)cachedHistory.getCustomData(), cachedHistory.getRevisions(), cachedHistory.getPath(), cachedHistory.getCurrentRevision());
        }
    }

    public void clearAll() {
        this.clearHistory();
        this.clearAnnotations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearHistory() {
        Object object = this.myLock;
        synchronized (object) {
            Iterator iterator = this.myHistoryCache.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = (Map.Entry)iterator.next();
                if (((HistoryCacheBaseKey)next.getKey()).getFilePath().isNonLocal()) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAnnotation(@NotNull FilePath filePath2, @NotNull VcsKey vcsKey, @NotNull VcsRevisionNumber number, @NotNull Object vcsAnnotation) {
        Object object = this.myLock;
        synchronized (object) {
            this.myAnnotationCache.put((Object)new HistoryCacheWithRevisionKey(filePath2, vcsKey, number), vcsAnnotation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAnnotation(@NotNull FilePath filePath2, @NotNull VcsKey vcsKey, @NotNull VcsRevisionNumber number) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myAnnotationCache.get((Object)new HistoryCacheWithRevisionKey(filePath2, vcsKey, number));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAnnotations() {
        Object object = this.myLock;
        synchronized (object) {
            this.myAnnotationCache.clear();
        }
    }

    public static class CachedHistory {
        private final FilePath myPath;
        private final List<VcsFileRevision> myRevisions;
        private final VcsRevisionNumber myCurrentRevision;
        private final Object myCustomData;
        private final boolean myIsFull;

        public CachedHistory(FilePath path2, List<VcsFileRevision> revisions, VcsRevisionNumber currentRevision, Object customData, boolean isFull) {
            this.myPath = path2;
            this.myRevisions = revisions;
            this.myCurrentRevision = currentRevision;
            this.myCustomData = customData;
            this.myIsFull = isFull;
        }

        public FilePath getPath() {
            return this.myPath;
        }

        public List<VcsFileRevision> getRevisions() {
            return this.myRevisions;
        }

        public VcsRevisionNumber getCurrentRevision() {
            return this.myCurrentRevision;
        }

        public Object getCustomData() {
            return this.myCustomData;
        }

        public boolean isIsFull() {
            return this.myIsFull;
        }
    }
}

