/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CurrentRevision
implements VcsFileRevision {
    private static final Logger LOG = Logger.getInstance(CurrentRevision.class);
    private final VirtualFile myFile;
    private final VcsRevisionNumber myRevisionNumber;

    public CurrentRevision(@NotNull VirtualFile file, @NotNull VcsRevisionNumber revision) {
        this.myFile = file;
        this.myRevisionNumber = revision;
    }

    @Override
    public String getCommitMessage() {
        return "[" + CurrentRevision.getCurrent() + "]";
    }

    @Override
    public byte[] getContent() {
        return this.loadContent();
    }

    @Override
    public Date getRevisionDate() {
        return new Date(this.myFile.getTimeStamp());
    }

    @Override
    public byte[] loadContent() {
        try {
            Document document = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(this.myFile));
            if (document != null) {
                return document.getText().getBytes(this.myFile.getCharset().name());
            }
            return this.myFile.contentsToByteArray();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @Override
    public String getAuthor() {
        return "";
    }

    @Override
    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        return this.myRevisionNumber;
    }

    @Override
    public String getBranchName() {
        return null;
    }

    @Override
    @Nullable
    public RepositoryLocation getChangedRepositoryPath() {
        return null;
    }

    public static String getCurrent() {
        return VcsBundle.message("vcs.revision.name.current", new Object[0]);
    }
}

