/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.vcs.VcsBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public interface VcsShowConfirmationOption {
    public static final VcsShowConfirmationOption STATIC_SHOW_CONFIRMATION = new VcsShowConfirmationOption(){

        @Override
        public Value getValue() {
            return Value.SHOW_CONFIRMATION;
        }

        @Override
        public void setValue(Value value) {
        }

        @Override
        public boolean isPersistent() {
            return false;
        }
    };

    @NotNull
    @Nls
    public static String getConfirmationOptionText(@NotNull Value value) {
        switch (value) {
            case SHOW_CONFIRMATION: {
                return VcsBundle.getString("settings.confirmation.option.text.ask");
            }
            case DO_NOTHING_SILENTLY: {
                return VcsBundle.getString("settings.confirmation.option.text.no");
            }
            case DO_ACTION_SILENTLY: {
                return VcsBundle.getString("settings.confirmation.option.text.yes");
            }
        }
        throw new IllegalArgumentException("Unknown confirmation option " + (Object)((Object)value));
    }

    public Value getValue();

    public void setValue(Value var1);

    public boolean isPersistent();

    public static enum Value {
        SHOW_CONFIRMATION,
        DO_NOTHING_SILENTLY,
        DO_ACTION_SILENTLY;


        public String toString() {
            return String.valueOf(this.ordinal());
        }

        public static Value fromString(@NotNull String s) {
            if (s.equals("1")) {
                return DO_NOTHING_SILENTLY;
            }
            if (s.equals("2")) {
                return DO_ACTION_SILENTLY;
            }
            return SHOW_CONFIRMATION;
        }
    }
}

