/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsRoot {
    @Nullable
    private final AbstractVcs myVcs;
    @NotNull
    private final VirtualFile myPath;
    private int hashcode;

    public VcsRoot(@Nullable AbstractVcs vcs, @NotNull VirtualFile path2) {
        this.myVcs = vcs;
        this.myPath = path2;
    }

    @Nullable
    public AbstractVcs getVcs() {
        return this.myVcs;
    }

    @NotNull
    public VirtualFile getPath() {
        return this.myPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsRoot root = (VcsRoot)o;
        if (!Objects.equals(this.myPath, root.myPath)) {
            return false;
        }
        return !(this.myVcs != null ? !this.myVcs.equals(root.myVcs) : root.myVcs != null);
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            this.hashcode = this.myVcs != null ? this.myVcs.hashCode() : 0;
            this.hashcode = 31 * this.hashcode + this.myPath.hashCode();
        }
        return this.hashcode;
    }

    public String toString() {
        return String.format("VcsRoot{vcs=%s, path=%s}", this.myVcs, this.myPath);
    }
}

