/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WindowState;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WindowStateService {
    private final Project project;

    protected WindowStateService(@Nullable Project project) {
        this.project = project;
    }

    public static WindowStateService getInstance() {
        return ServiceManager.getService(WindowStateService.class);
    }

    public static WindowStateService getInstance(@NotNull Project project) {
        return ServiceManager.getService(project, WindowStateService.class);
    }

    public final WindowState getState(@NotNull String key, @NotNull Window window) {
        return this.getStateFor(this.project, key, window);
    }

    public abstract WindowState getStateFor(@Nullable Project var1, @NotNull String var2, @NotNull Window var3);

    public final Point getLocation(@NotNull String key) {
        return this.getLocationFor(this.project, key);
    }

    public abstract Point getLocationFor(Object var1, @NotNull String var2);

    public final void putLocation(@NotNull String key, Point location) {
        this.putLocationFor(this.project, key, location);
    }

    public abstract void putLocationFor(Object var1, @NotNull String var2, Point var3);

    public final Dimension getSize(@NotNull String key) {
        return this.getSizeFor(this.project, key);
    }

    public abstract Dimension getSizeFor(Object var1, @NotNull String var2);

    public final void putSize(@NotNull String key, Dimension size) {
        this.putSizeFor(this.project, key, size);
    }

    public abstract void putSizeFor(Object var1, @NotNull String var2, Dimension var3);

    public final Rectangle getBounds(@NotNull String key) {
        return this.getBoundsFor(this.project, key);
    }

    public abstract Rectangle getBoundsFor(Object var1, @NotNull String var2);

    public final void putBounds(@NotNull String key, Rectangle bounds) {
        this.putBoundsFor(this.project, key, bounds);
    }

    public abstract void putBoundsFor(Object var1, @NotNull String var2, Rectangle var3);
}

