/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.WindowStateService;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JFrame;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DimensionService", storages={@Storage(value="window.state.xml", roamingType=RoamingType.DISABLED), @Storage(value="dimensions.xml", roamingType=RoamingType.DISABLED, deprecated=true)})
public final class DimensionService
extends SimpleModificationTracker
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(DimensionService.class);
    private final Object2ObjectMap<String, Point> myKeyToLocation = new Object2ObjectLinkedOpenHashMap();
    private final Object2ObjectMap<String, Dimension> myKeToSize = new Object2ObjectLinkedOpenHashMap();
    private final Object2IntMap<String> myKeyToExtendedState = new Object2IntOpenHashMap();
    @NonNls
    private static final String EXTENDED_STATE = "extendedState";
    @NonNls
    private static final String KEY = "key";
    @NonNls
    private static final String STATE = "state";
    @NonNls
    private static final String ELEMENT_LOCATION = "location";
    @NonNls
    private static final String ELEMENT_SIZE = "size";
    @NonNls
    private static final String ATTRIBUTE_X = "x";
    @NonNls
    private static final String ATTRIBUTE_Y = "y";
    @NonNls
    private static final String ATTRIBUTE_WIDTH = "width";
    @NonNls
    private static final String ATTRIBUTE_HEIGHT = "height";

    public static DimensionService getInstance() {
        return ServiceManager.getService(DimensionService.class);
    }

    @Nullable
    public synchronized Point getLocation(String key) {
        return this.getLocation(key, DimensionService.guessProject());
    }

    @Nullable
    public synchronized Point getLocation(@NotNull String key, Project project) {
        Point point;
        Point point2 = point = project == null ? null : WindowStateService.getInstance(project).getLocation(key);
        if (point != null) {
            return point;
        }
        Pair<String, Float> pair = DimensionService.keyPair(key, project);
        point = (Point)this.myKeyToLocation.get(pair.first);
        if (point != null) {
            point = (Point)point.clone();
            float scale = ((Float)pair.second).floatValue();
            point.setLocation((float)point.x / scale, (float)point.y / scale);
        }
        if (point != null && !ScreenUtil.getScreenRectangle((Point)point).contains(point)) {
            point = null;
        }
        return point;
    }

    public synchronized void setLocation(String key, Point point) {
        this.setLocation(key, point, DimensionService.guessProject());
    }

    public synchronized void setLocation(@NotNull String key, Point point, Project project) {
        DimensionService.getWindowStateService(project).putLocation(key, point);
        Pair<String, Float> pair = DimensionService.keyPair(key, project);
        if (point != null) {
            point = (Point)point.clone();
            float scale = ((Float)pair.second).floatValue();
            point.setLocation((float)point.x * scale, (float)point.y * scale);
            this.myKeyToLocation.put(pair.first, (Object)point);
        } else {
            this.myKeyToLocation.remove((Object)key);
        }
        this.incModificationCount();
    }

    @Nullable
    public synchronized Dimension getSize(@NotNull @NonNls String key) {
        return this.getSize(key, DimensionService.guessProject());
    }

    @Nullable
    public synchronized Dimension getSize(@NotNull @NonNls String key, Project project) {
        Dimension size;
        Dimension dimension = size = project == null ? null : WindowStateService.getInstance(project).getSize(key);
        if (size != null) {
            return size;
        }
        Pair<String, Float> pair = DimensionService.keyPair(key, project);
        size = (Dimension)this.myKeToSize.get(pair.first);
        if (size != null) {
            size = (Dimension)size.clone();
            float scale = ((Float)pair.second).floatValue();
            size.setSize((float)size.width / scale, (float)size.height / scale);
        }
        return size;
    }

    public synchronized void setSize(@NotNull @NonNls String key, Dimension size) {
        this.setSize(key, size, DimensionService.guessProject());
    }

    public synchronized void setSize(@NotNull @NonNls String key, Dimension size, Project project) {
        DimensionService.getWindowStateService(project).putSize(key, size);
        Pair<String, Float> pair = DimensionService.keyPair(key, project);
        if (size != null) {
            size = (Dimension)size.clone();
            float scale = ((Float)pair.second).floatValue();
            size.setSize((float)size.width * scale, (float)size.height * scale);
            this.myKeToSize.put(pair.first, (Object)size);
        } else {
            this.myKeToSize.remove(pair.first);
        }
        this.incModificationCount();
    }

    @Override
    public Element getState() {
        Element e;
        Element element = new Element(STATE);
        for (Object2ObjectMap.Entry entry : Object2ObjectMaps.fastIterable(this.myKeyToLocation)) {
            Point point = (Point)entry.getValue();
            LOG.assertTrue(point != null);
            e = new Element(ELEMENT_LOCATION);
            e.setAttribute(KEY, (String)entry.getKey());
            e.setAttribute(ATTRIBUTE_X, String.valueOf(point.x));
            e.setAttribute(ATTRIBUTE_Y, String.valueOf(point.y));
            element.addContent(e);
        }
        for (Object2ObjectMap.Entry entry : Object2ObjectMaps.fastIterable(this.myKeToSize)) {
            Dimension size = (Dimension)entry.getValue();
            LOG.assertTrue(size != null);
            e = new Element(ELEMENT_SIZE);
            e.setAttribute(KEY, (String)entry.getKey());
            e.setAttribute(ATTRIBUTE_WIDTH, String.valueOf(size.width));
            e.setAttribute(ATTRIBUTE_HEIGHT, String.valueOf(size.height));
            element.addContent(e);
        }
        for (Object2ObjectMap.Entry entry : Object2IntMaps.fastIterable(this.myKeyToExtendedState)) {
            Element e2 = new Element(EXTENDED_STATE);
            e2.setAttribute(KEY, (String)entry.getKey());
            e2.setAttribute(STATE, Integer.toString(entry.getIntValue()));
            element.addContent(e2);
        }
        return element;
    }

    @Override
    public void loadState(@NotNull Element element) {
        this.myKeyToLocation.clear();
        this.myKeToSize.clear();
        this.myKeyToExtendedState.clear();
        for (Element e : element.getChildren()) {
            if (ELEMENT_LOCATION.equals(e.getName())) {
                try {
                    this.myKeyToLocation.put((Object)e.getAttributeValue(KEY), (Object)new Point(Integer.parseInt(e.getAttributeValue(ATTRIBUTE_X)), Integer.parseInt(e.getAttributeValue(ATTRIBUTE_Y))));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (ELEMENT_SIZE.equals(e.getName())) {
                try {
                    this.myKeToSize.put((Object)e.getAttributeValue(KEY), (Object)new Dimension(Integer.parseInt(e.getAttributeValue(ATTRIBUTE_WIDTH)), Integer.parseInt(e.getAttributeValue(ATTRIBUTE_HEIGHT))));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!EXTENDED_STATE.equals(e.getName())) continue;
            try {
                this.myKeyToExtendedState.put((Object)e.getAttributeValue(KEY), Integer.parseInt(e.getAttributeValue(STATE)));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    @Nullable
    private static Project guessProject() {
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        return openProjects.length == 1 ? openProjects[0] : null;
    }

    @NotNull
    private static Pair<String, Float> keyPair(String key, @Nullable Project project) {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (env.isHeadlessInstance()) {
            return new Pair((Object)(key + ".headless"), (Object)Float.valueOf(1.0f));
        }
        JFrame frame = null;
        Component owner = IdeFocusManager.findInstance().getFocusOwner();
        if (owner != null) {
            frame = (JFrame)ComponentUtil.getParentOfType(JFrame.class, (Component)owner);
        }
        if (frame == null) {
            frame = WindowManager.getInstance().findVisibleFrame();
        }
        if (project != null && (frame == null || frame instanceof IdeFrame && project != ((IdeFrame)((Object)frame)).getProject())) {
            frame = WindowManager.getInstance().getFrame(project);
        }
        Rectangle screen = new Rectangle(0, 0, 0, 0);
        GraphicsDevice gd = null;
        if (frame != null) {
            Point topLeft = frame.getLocation();
            float centerX = (float)topLeft.x + (float)frame.getWidth() / 2.0f;
            float centerY = (float)topLeft.y + (float)frame.getHeight() / 2.0f;
            for (GraphicsDevice device : env.getScreenDevices()) {
                Rectangle bounds = device.getDefaultConfiguration().getBounds();
                if (!bounds.contains(centerX, centerY)) continue;
                screen = bounds;
                gd = device;
                break;
            }
        }
        if (gd == null) {
            gd = env.getDefaultScreenDevice();
            screen = gd.getDefaultConfiguration().getBounds();
        }
        float scale = 1.0f;
        if (JreHiDpiUtil.isJreHiDPIEnabled()) {
            scale = JBUIScale.sysScale((GraphicsConfiguration)gd.getDefaultConfiguration());
            screen.setBounds((int)Math.floor((float)screen.x * scale), (int)Math.floor((float)screen.y * scale), (int)Math.ceil((float)screen.width * scale), (int)Math.ceil((float)screen.height * scale));
        }
        String realKey = key + '.' + screen.x + '.' + screen.y + '.' + screen.width + '.' + screen.height;
        if (JBUI.isPixHiDPI((GraphicsConfiguration)gd.getDefaultConfiguration())) {
            int dpi = (int)(96.0f * JBUI.pixScale((GraphicsConfiguration)gd.getDefaultConfiguration()));
            realKey = realKey + "@" + dpi + "dpi";
        }
        return new Pair((Object)realKey, (Object)Float.valueOf(scale));
    }

    @NotNull
    private static WindowStateService getWindowStateService(@Nullable Project project) {
        return project == null ? WindowStateService.getInstance() : WindowStateService.getInstance(project);
    }
}

