/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.popup;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.ui.popup.TreePopup;
import com.intellij.openapi.ui.popup.TreePopupStep;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JBPopupFactory {
    public static JBPopupFactory getInstance() {
        return ServiceManager.getService(JBPopupFactory.class);
    }

    @NotNull
    public abstract <T> IPopupChooserBuilder<T> createPopupChooserBuilder(@NotNull List<? extends T> var1);

    @NotNull
    public PopupChooserBuilder createPopupChooserBuilder(@NotNull JTable table) {
        return new PopupChooserBuilder(table);
    }

    @Deprecated
    @NotNull
    public <T> PopupChooserBuilder<T> createListPopupBuilder(@NotNull JList<T> list) {
        return new PopupChooserBuilder<T>(list);
    }

    @NotNull
    public abstract ListPopup createConfirmation(@NlsContexts.PopupTitle String var1, Runnable var2, int var3);

    @NotNull
    public abstract ListPopup createConfirmation(@NlsContexts.PopupTitle String var1, @NlsContexts.Label String var2, @NlsContexts.Label String var3, Runnable var4, int var5);

    @NotNull
    public abstract ListPopup createConfirmation(@NlsContexts.PopupTitle String var1, @NlsContexts.Label String var2, @NlsContexts.Label String var3, Runnable var4, Runnable var5, int var6);

    @Deprecated
    @NotNull
    public ListPopupStep createActionsStep(@NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean showDisabledActions, @NlsContexts.PopupTitle String title, Component component, boolean honorActionMnemonics) {
        return this.createActionsStep(actionGroup, dataContext, null, showNumbers, showDisabledActions, title, component, honorActionMnemonics, 0, false);
    }

    @Deprecated
    @NotNull
    public ListPopupStep createActionsStep(@NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean showDisabledActions, @NlsContexts.PopupTitle String title, Component component, boolean honorActionMnemonics, int defaultOptionIndex, boolean autoSelectionEnabled) {
        return this.createActionsStep(actionGroup, dataContext, null, showNumbers, showDisabledActions, title, component, honorActionMnemonics, defaultOptionIndex, autoSelectionEnabled);
    }

    @NotNull
    public abstract ListPopupStep createActionsStep(@NotNull ActionGroup var1, @NotNull DataContext var2, @Nullable String var3, boolean var4, boolean var5, @NlsContexts.PopupTitle String var6, Component var7, boolean var8, int var9, boolean var10);

    @NotNull
    public abstract RelativePoint guessBestPopupLocation(@NotNull JComponent var1);

    public boolean isChildPopupFocused(@Nullable Component parent) {
        return this.getChildFocusedPopup(parent) != null;
    }

    public JBPopup getChildFocusedPopup(@Nullable Component parent) {
        if (parent == null) {
            return null;
        }
        List<JBPopup> popups = this.getChildPopups(parent);
        for (JBPopup each : popups) {
            JBPopup childFocusedPopup;
            if (each.isFocused()) {
                return each;
            }
            if (each.isDisposed() || (childFocusedPopup = this.getChildFocusedPopup(each.getContent())) == null) continue;
            return childFocusedPopup;
        }
        return null;
    }

    @NotNull
    public ListPopup createActionGroupPopup(@Nullable @NlsContexts.PopupTitle String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, ActionSelectionAid selectionAidMethod, boolean showDisabledActions) {
        return this.createActionGroupPopup(title, actionGroup, dataContext, selectionAidMethod, showDisabledActions, null, -1, null, null);
    }

    @NotNull
    public ListPopup createActionGroupPopup(@NlsContexts.PopupTitle String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, ActionSelectionAid selectionAidMethod, boolean showDisabledActions, @Nullable String actionPlace) {
        return this.createActionGroupPopup(title, actionGroup, dataContext, selectionAidMethod, showDisabledActions, null, -1, null, actionPlace);
    }

    @NotNull
    public ListPopup createActionGroupPopup(@NlsContexts.PopupTitle String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, ActionSelectionAid selectionAidMethod, boolean showDisabledActions, Runnable disposeCallback, int maxRowCount) {
        return this.createActionGroupPopup(title, actionGroup, dataContext, selectionAidMethod, showDisabledActions, disposeCallback, maxRowCount, null, null);
    }

    @NotNull
    public ListPopup createActionGroupPopup(@NlsContexts.PopupTitle String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showDisabledActions, @Nullable Runnable disposeCallback, int maxRowCount) {
        return this.createActionGroupPopup(title, actionGroup, dataContext, ActionSelectionAid.SPEEDSEARCH, showDisabledActions, disposeCallback, maxRowCount);
    }

    @NotNull
    public abstract ListPopup createActionGroupPopup(@NlsContexts.PopupTitle String var1, @NotNull ActionGroup var2, @NotNull DataContext var3, boolean var4, boolean var5, boolean var6, @Nullable Runnable var7, int var8, @Nullable Condition<? super AnAction> var9);

    @NotNull
    public abstract ListPopup createActionGroupPopup(@NlsContexts.PopupTitle String var1, @NotNull ActionGroup var2, @NotNull DataContext var3, ActionSelectionAid var4, boolean var5, @Nullable Runnable var6, int var7, @Nullable Condition<? super AnAction> var8, @Nullable String var9);

    @NotNull
    public abstract ListPopup createListPopup(@NotNull ListPopupStep var1);

    @NotNull
    public abstract ListPopup createListPopup(@NotNull ListPopupStep var1, int var2);

    @NotNull
    public abstract TreePopup createTree(JBPopup var1, @NotNull TreePopupStep var2, Object var3);

    @NotNull
    public abstract TreePopup createTree(@NotNull TreePopupStep var1);

    @NotNull
    public abstract ComponentPopupBuilder createComponentPopupBuilder(@NotNull JComponent var1, @Nullable JComponent var2);

    @NotNull
    public abstract RelativePoint guessBestPopupLocation(@NotNull DataContext var1);

    @NotNull
    public abstract RelativePoint guessBestPopupLocation(@NotNull Editor var1);

    public abstract boolean isBestPopupLocationVisible(@NotNull Editor var1);

    public abstract Point getCenterOf(JComponent var1, JComponent var2);

    @NotNull
    public abstract List<JBPopup> getChildPopups(@NotNull Component var1);

    public abstract boolean isPopupActive();

    @NotNull
    public abstract BalloonBuilder createBalloonBuilder(@NotNull JComponent var1);

    @NotNull
    public abstract BalloonBuilder createDialogBalloonBuilder(@NotNull JComponent var1, @NlsContexts.PopupTitle String var2);

    @NotNull
    public BalloonBuilder createHtmlTextBalloonBuilder(@NotNull @NlsContexts.PopupContent String htmlContent, @Nullable Icon icon, Color fillColor, @Nullable HyperlinkListener listener2) {
        return this.createHtmlTextBalloonBuilder(htmlContent, icon, null, fillColor, listener2);
    }

    @NotNull
    public abstract BalloonBuilder createHtmlTextBalloonBuilder(@NotNull @NlsContexts.PopupContent String var1, @Nullable Icon var2, Color var3, Color var4, @Nullable HyperlinkListener var5);

    @NotNull
    public abstract BalloonBuilder createHtmlTextBalloonBuilder(@NotNull @NlsContexts.PopupContent String var1, MessageType var2, @Nullable HyperlinkListener var3);

    @NotNull
    public abstract JBPopup createMessage(@NlsContexts.PopupContent String var1);

    @Nullable
    public abstract Balloon getParentBalloonFor(@Nullable Component var1);

    @NotNull
    protected abstract <T> PopupChooserBuilder.PopupComponentAdapter<T> createPopupComponentAdapter(@NotNull PopupChooserBuilder<T> var1, @NotNull JList<T> var2);

    @NotNull
    protected abstract <T> PopupChooserBuilder.PopupComponentAdapter<T> createPopupComponentAdapter(@NotNull PopupChooserBuilder<T> var1, @NotNull JTree var2);

    @NotNull
    protected abstract <T> PopupChooserBuilder.PopupComponentAdapter<T> createPopupComponentAdapter(@NotNull PopupChooserBuilder<T> var1, @NotNull JTable var2);

    public static enum ActionSelectionAid {
        NUMBERING,
        ALPHA_NUMBERING,
        SPEEDSEARCH,
        MNEMONICS;

    }
}

