/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.panel;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.ui.panel.GridBagPanelBuilder;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.ui.panel.ProgressPanel;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.SeparatorComponent;
import com.intellij.ui.SeparatorOrientation;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressPanelBuilder
implements GridBagPanelBuilder,
PanelBuilder {
    private static final Color SEPARATOR_COLOR = JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground();
    private final JProgressBar myProgressBar;
    private String initialLabelText;
    private boolean labelAbove = true;
    private Runnable cancelAction;
    private Runnable resumeAction;
    private Runnable pauseAction;
    private String cancelText = "Cancel";
    private boolean cancelAsButton;
    private boolean smallVariant;
    private boolean commentEnabled = true;
    private boolean text2Enabled;
    private boolean topSeparatorEnabled;

    public ProgressPanelBuilder(JProgressBar progressBar) {
        this.myProgressBar = progressBar;
    }

    public ProgressPanelBuilder withLabel(@NotNull String text) {
        this.initialLabelText = text;
        return this;
    }

    public ProgressPanelBuilder moveLabelLeft() {
        this.labelAbove = false;
        return this;
    }

    public ProgressPanelBuilder withCancel(@NotNull Runnable cancelAction) {
        this.cancelAction = cancelAction;
        return this;
    }

    public ProgressPanelBuilder andCancelText(String cancelText) {
        this.cancelText = cancelText;
        return this;
    }

    public ProgressPanelBuilder andCancelAsButton() {
        this.cancelAsButton = true;
        return this;
    }

    public ProgressPanelBuilder withResume(@NotNull Runnable playAction) {
        this.resumeAction = playAction;
        return this;
    }

    public ProgressPanelBuilder withPause(@NotNull Runnable pauseAction) {
        this.pauseAction = pauseAction;
        return this;
    }

    public ProgressPanelBuilder andSmallIcons() {
        this.smallVariant = true;
        return this;
    }

    public ProgressPanelBuilder withoutComment() {
        this.commentEnabled = false;
        return this;
    }

    @NotNull
    public ProgressPanelBuilder withText2() {
        this.text2Enabled = true;
        return this;
    }

    public ProgressPanelBuilder withTopSeparator() {
        this.topSeparatorEnabled = true;
        return this;
    }

    @Override
    @NotNull
    public JPanel createPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 2, null, 0, 0);
        this.addToPanel(panel2, gc, false);
        return panel2;
    }

    @Override
    public boolean constrainsValid() {
        return true;
    }

    @Override
    public void addToPanel(JPanel panel2, GridBagConstraints gc, boolean splitColumns) {
        if (this.constrainsValid()) {
            new LabeledPanelImpl().addToPanel(panel2, gc);
        }
    }

    @Override
    public int gridWidth() {
        int width = this.labelAbove ? 1 : 2;
        width += this.cancelAction != null ? 1 : 0;
        return width += this.resumeAction != null && this.pauseAction != null ? 1 : 0;
    }

    static /* synthetic */ Color access$200() {
        return SEPARATOR_COLOR;
    }

    private class LabeledPanelImpl
    extends ProgressPanel {
        private final JLabel label;
        private final JLabel comment;
        private final JLabel text2;
        private String myCommentText = this.emptyComment();
        private boolean myServiceComment = false;
        private final IconButton cancelIcon;
        private final IconButton resumeIcon;
        private final IconButton pauseIcon;
        private JButton myCancelButtonAsButton;
        private InplaceButton myCancelButton;
        private InplaceButton mySuspendButton;
        private final SeparatorComponent mySeparatorComponent = new SeparatorComponent(ProgressPanelBuilder.access$200(), SeparatorOrientation.HORIZONTAL);
        private ProgressPanel.State state = ProgressPanel.State.PLAYING;

        private LabeledPanelImpl() {
            this.label = new JLabel(StringUtil.isNotEmpty((String)ProgressPanelBuilder.this.initialLabelText) ? ProgressPanelBuilder.this.initialLabelText : " ");
            this.comment = new JLabel(this.myCommentText);
            this.comment.setForeground(UIUtil.getContextHelpForeground());
            if (ProgressPanelBuilder.this.text2Enabled) {
                this.text2 = new JLabel();
                this.text2.setForeground(UIUtil.getContextHelpForeground());
            } else {
                this.text2 = null;
            }
            if (SystemInfo.isMac) {
                Font font = this.comment.getFont();
                float size = font.getSize2D();
                Font smallFont = font.deriveFont(size - 2.0f);
                this.comment.setFont(smallFont);
                if (this.text2 != null) {
                    this.text2.setFont(smallFont);
                }
            }
            if (StringUtil.isNotEmpty((String)ProgressPanelBuilder.this.initialLabelText)) {
                Dimension size = this.comment.getPreferredSize();
                size.width = this.label.getMinimumSize().width;
                this.comment.setMinimumSize(size);
                if (this.text2 != null) {
                    this.text2.setMinimumSize(size);
                }
            }
            this.cancelIcon = new IconButton(null, ProgressPanelBuilder.this.smallVariant ? AllIcons.Process.StopSmall : AllIcons.Process.Stop, ProgressPanelBuilder.this.smallVariant ? AllIcons.Process.StopSmallHovered : AllIcons.Process.StopHovered);
            this.resumeIcon = new IconButton(null, ProgressPanelBuilder.this.smallVariant ? AllIcons.Process.ProgressResumeSmall : AllIcons.Process.ProgressResume, ProgressPanelBuilder.this.smallVariant ? AllIcons.Process.ProgressResumeSmallHover : AllIcons.Process.ProgressResumeHover);
            this.pauseIcon = new IconButton(null, ProgressPanelBuilder.this.smallVariant ? AllIcons.Process.ProgressPauseSmall : AllIcons.Process.ProgressPause, ProgressPanelBuilder.this.smallVariant ? AllIcons.Process.ProgressPauseSmallHover : AllIcons.Process.ProgressPauseHover);
        }

        private String emptyComment() {
            return ProgressPanelBuilder.this.commentEnabled ? " " : "";
        }

        @Override
        public String getLabelText() {
            return this.label.getText();
        }

        @Override
        public void setLabelText(String labelText) {
            this.label.setText(StringUtil.isNotEmpty((String)labelText) ? labelText : " ");
            if (StringUtil.isNotEmpty((String)labelText)) {
                Dimension size = this.comment.getPreferredSize();
                size.width = this.label.getMinimumSize().width;
                this.comment.setMinimumSize(size);
                if (this.text2 != null) {
                    this.text2.setMinimumSize(size);
                }
            }
        }

        @Override
        public String getCommentText() {
            return this.myServiceComment ? this.myCommentText : this.comment.getText();
        }

        @Override
        public void setCommentText(String commentText) {
            if (ProgressPanelBuilder.this.commentEnabled) {
                this.setCommentText(commentText, false);
            }
        }

        @Override
        public void setLabelEnabled(boolean enabled) {
            this.label.setEnabled(enabled);
        }

        @Override
        public void setCommentEnabled(boolean enabled) {
            this.comment.setEnabled(enabled);
        }

        @Override
        public void setText2(@Nullable String text) {
            if (this.text2 != null) {
                boolean empty = StringUtil.isEmpty((String)text);
                if (empty && !this.text2.isVisible()) {
                    return;
                }
                this.text2.setText(empty ? " " : text);
                this.text2.setVisible(true);
            }
        }

        @Override
        public void setText2Enabled(boolean enabled) {
            if (this.text2 != null) {
                this.text2.setEnabled(enabled);
            }
        }

        @Override
        public void setSeparatorEnabled(boolean enabled) {
            this.mySeparatorComponent.setVisible(enabled);
        }

        @Override
        @Nullable
        public JButton getCancelButtonAsButton() {
            return this.myCancelButtonAsButton;
        }

        @Override
        @Nullable
        public InplaceButton getCancelButton() {
            return this.myCancelButton;
        }

        @Override
        @Nullable
        public InplaceButton getSuspendButton() {
            return this.mySuspendButton;
        }

        private void setCommentText(String commentText, boolean serviceComment) {
            if (serviceComment) {
                this.myServiceComment = commentText != null;
                this.comment.setText(commentText == null ? this.myCommentText : commentText);
            } else {
                String string = this.myCommentText = StringUtil.isNotEmpty((String)commentText) ? commentText : this.emptyComment();
                if (!this.myServiceComment) {
                    this.comment.setText(this.myCommentText);
                }
            }
        }

        @Override
        @NotNull
        public ProgressPanel.State getState() {
            return this.state;
        }

        @Override
        public void setState(@NotNull ProgressPanel.State state) {
            if (this.state == state || state == ProgressPanel.State.CANCELLED || this.mySuspendButton == null) {
                return;
            }
            this.state = state;
            if (state == ProgressPanel.State.PLAYING) {
                this.mySuspendButton.setIcons(this.pauseIcon);
                this.setCommentText(null, true);
            } else {
                this.mySuspendButton.setIcons(this.resumeIcon);
                this.setCommentText(IdeBundle.message("comment.text.paused", new Object[0]), true);
            }
            this.mySuspendButton.revalidate();
            this.mySuspendButton.repaint();
        }

        private void addToPanel(JPanel panel2, GridBagConstraints gc) {
            gc.gridx = 0;
            gc.anchor = 21;
            gc.fill = 2;
            if (ProgressPanelBuilder.this.topSeparatorEnabled) {
                gc.insets = JBUI.insets((int)14, (int)0, (int)10, (int)0);
                gc.gridwidth = ProgressPanelBuilder.this.gridWidth();
                gc.weightx = 1.0;
                panel2.add((Component)this.mySeparatorComponent, gc);
                ++gc.gridy;
            }
            gc.weightx = 0.0;
            gc.gridwidth = 1;
            gc.insets = JBUI.insets((int)(ProgressPanelBuilder.this.topSeparatorEnabled || ProgressPanelBuilder.this.smallVariant ? 0 : 12), (int)13, (int)0, (int)(ProgressPanelBuilder.this.labelAbove ? 13 : 0));
            panel2.add((Component)this.label, gc);
            if (ProgressPanelBuilder.this.labelAbove) {
                gc.insets = JBUI.insets((int)4, (int)13, (int)4, (int)0);
                ++gc.gridy;
            } else {
                gc.insets = JBUI.insets((int)(ProgressPanelBuilder.this.topSeparatorEnabled || ProgressPanelBuilder.this.smallVariant ? 2 : 14), (int)12, (int)0, (int)0);
                ++gc.gridx;
            }
            gc.weightx = 1.0;
            panel2.add((Component)ProgressPanelBuilder.this.myProgressBar, gc);
            ++gc.gridx;
            ProgressPanelBuilder.this.myProgressBar.putClientProperty("JComponent.decoratedPanel", this);
            gc.weightx = 0.0;
            gc.insets = JBUI.insets((int)(ProgressPanelBuilder.this.labelAbove || ProgressPanelBuilder.this.topSeparatorEnabled || ProgressPanelBuilder.this.smallVariant ? 1 : 14), (int)(UIUtil.isUnderWin10LookAndFeel() ? 9 : 10), (int)0, (int)13);
            if (ProgressPanelBuilder.this.cancelAction != null) {
                if (ProgressPanelBuilder.this.cancelAsButton) {
                    this.myCancelButtonAsButton = new JButton(ProgressPanelBuilder.this.cancelText);
                    this.myCancelButtonAsButton.addActionListener(e -> ProgressPanelBuilder.this.cancelAction.run());
                    panel2.add((Component)this.myCancelButtonAsButton, gc);
                } else {
                    this.myCancelButton = new InplaceButton(this.cancelIcon, a -> {
                        this.myCancelButton.setPainting(false);
                        this.state = ProgressPanel.State.CANCELLED;
                        ProgressPanelBuilder.this.cancelAction.run();
                    }).setFillBg(false);
                }
            }
            if (ProgressPanelBuilder.this.resumeAction != null && ProgressPanelBuilder.this.pauseAction != null) {
                this.mySuspendButton = new InplaceButton(this.pauseIcon, a -> {
                    if (this.state == ProgressPanel.State.CANCELLED) {
                        return;
                    }
                    if (this.state == ProgressPanel.State.PLAYING) {
                        this.mySuspendButton.setIcons(this.resumeIcon);
                        this.state = ProgressPanel.State.PAUSED;
                        this.setCommentText(IdeBundle.message("comment.text.resume", new Object[0]), true);
                        ProgressPanelBuilder.this.pauseAction.run();
                    } else {
                        this.mySuspendButton.setIcons(this.pauseIcon);
                        this.state = ProgressPanel.State.PLAYING;
                        this.setCommentText(IdeBundle.message("comment.text.pause", new Object[0]), true);
                        ProgressPanelBuilder.this.resumeAction.run();
                    }
                }).setFillBg(false);
            }
            if (this.mySuspendButton != null) {
                this.addButton(panel2, gc, this.mySuspendButton, false);
            }
            if (this.myCancelButton != null) {
                if (this.mySuspendButton != null) {
                    ++gc.gridx;
                }
                this.addButton(panel2, gc, this.myCancelButton, true);
            }
            if (ProgressPanelBuilder.this.commentEnabled) {
                this.addLabel(panel2, gc, this.comment);
            }
            if (this.text2 != null) {
                this.addLabel(panel2, gc, this.text2);
                this.text2.setVisible(false);
            }
            ++gc.gridy;
        }

        private void addLabel(@NotNull JPanel panel2, @NotNull GridBagConstraints gc, @NotNull JComponent label) {
            ++gc.gridy;
            gc.gridx = ProgressPanelBuilder.this.labelAbove ? 0 : 1;
            gc.insets = ProgressPanelBuilder.this.labelAbove ? JBUI.insets((int)-1, (int)13, (int)0, (int)13) : JBUI.insets((int)-1, (int)12, (int)0, (int)13);
            gc.weightx = 1.0;
            gc.anchor = 21;
            gc.fill = 2;
            panel2.add((Component)label, gc);
        }

        private void addButton(@NotNull JPanel panel2, @NotNull GridBagConstraints gc, @NotNull InplaceButton button, boolean cancel) {
            button.setMinimumSize(button.getPreferredSize());
            if (ProgressPanelBuilder.this.commentEnabled) {
                button.addMouseListener(new HoverListener(cancel));
            }
            gc.anchor = 13;
            gc.fill = 0;
            panel2.add((Component)button, gc);
        }

        private class HoverListener
        extends MouseAdapter {
            private final boolean myCancel;

            private HoverListener(boolean cancel) {
                this.myCancel = cancel;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (this.myCancel) {
                    LabeledPanelImpl.this.setCommentText(ProgressPanelBuilder.this.cancelText, true);
                } else {
                    LabeledPanelImpl.this.setCommentText(LabeledPanelImpl.this.state == ProgressPanel.State.PLAYING ? IdeBundle.message("comment.text.pause", new Object[0]) : IdeBundle.message("comment.text.resume", new Object[0]), true);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LabeledPanelImpl.this.setCommentText(LabeledPanelImpl.this.state == ProgressPanel.State.PAUSED ? IdeBundle.message("comment.text.paused", new Object[0]) : null, true);
            }
        }
    }
}

